package com.hupu.tv.player.app.ui.adapter;

import android.view.View;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.softgarden.baselibrary.base.BaseActivity;
import com.hupu.tv.player.app.R;
import com.hupu.tv.player.app.bean.BuyCoinBean;
import com.hupu.tv.player.app.utils.GlideUtils;

/**
 * @author by Dell
 * @date on 2020/6/15
 * @describe
 */
public class MineBuyAdapter extends BaseQuickAdapter<BuyCoinBean.DataListBean, BaseViewHolder> {
    private BaseActivity baseActivity;

    public MineBuyAdapter(int layoutResId, BaseActivity activity) {
        super(layoutResId);
        baseActivity = activity;
    }

    @Override
    protected void convert(BaseViewHolder helper,BuyCoinBean.DataListBean item) {
        View view = helper.getView(R.id.ll_coin);
        if (item.getBuyGoldCoin() == 0){
            view.setVisibility(View.INVISIBLE);
        }else {
            view.setVisibility(View.VISIBLE);
        }
        helper.setText(R.id.tv_title, item.getMovieTitle())
        .setText(R.id.tv_coin,String.valueOf(item.getBuyGoldCoin()));
        GlideUtils.loadRoundCircleImageCenterCrop(baseActivity,  item.getMovieEnCover(), helper.getView(R.id.iv_cover), 4,R.mipmap.bg_place_holder_history_collection);
//        helper.addOnClickListener(R.id.iv_start);
    }
}
