package com.hupu.tv.player.app.ui.adapter;


import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;

import com.arialyy.aria.core.inf.IEntity;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.softgarden.baselibrary.base.BaseActivity;
import com.hupu.tv.player.app.R;
import com.hupu.tv.player.app.bean.MovieBean;
import com.hupu.tv.player.app.utils.GlideUtils;

import java.util.ArrayList;
import java.util.List;


/**
 * @author by Dell
 * @date on 2020/6/15
 * @describe
 */
public class MineDownloadMoreAdapter extends BaseQuickAdapter<MovieBean.RecordsBean, BaseViewHolder> {
    private BaseActivity baseActivity;
    private OnNotifyListener onNotifyListener;

    public MineDownloadMoreAdapter(int layoutResId, BaseActivity activity) {
        super(layoutResId);
        baseActivity = activity;
    }


    public void setOnNotifyListener(OnNotifyListener onNotifyListener) {
        this.onNotifyListener = onNotifyListener;
    }

    @Override
    protected void convert(BaseViewHolder helper, MovieBean.RecordsBean item) {
        TextView tvSize = helper.getView(R.id.tv_size);
        TextView tvWatch = helper.getView(R.id.tv_is_watch);
        String title;
        if (TextUtils.isEmpty(item.getVideoTitle())) {
            title = item.getMovieTitle();
        } else {
            title = item.getVideoTitle();
        }
        ImageView ivSelect = helper.getView(R.id.iv_select);
        if (item.isEdit()) {
            ivSelect.setVisibility(View.VISIBLE);
        } else {
            ivSelect.setVisibility(View.GONE);
        }
        ivSelect.setSelected(item.isSelected());


        String imageUrl;
        if (TextUtils.isEmpty(item.getVideoEnCover())) {
            imageUrl = item.getMovieEnCover();
        } else {
            imageUrl = item.getVideoEnCover();
        }
        helper.setText(R.id.tv_title, title);
        ImageView view = helper.getView(R.id.iv_download);
//        if ()
        GlideUtils.loadRoundCircleImageCenterCrop(baseActivity, imageUrl, helper.getView(R.id.iv_download), 4,R.mipmap.bg_place_holder_download);
        setProgressText(tvSize, item);
        setStateText(tvWatch, item);
        helper.addOnClickListener(R.id.iv_select);
    }

    public void setEditStatus(boolean editStatus) {
        for (MovieBean.RecordsBean datum : this.getData()) {
            datum.setEdit(editStatus);
        }
        notifyItemRangeChanged(0, getData().size(), "refresh");
    }


    private void setProgressText(TextView tvSize, MovieBean.RecordsBean bean) {

        switch (bean.getState()) {
            case IEntity.STATE_COMPLETE:
                tvSize.setText(bean.getVideoSize());
                break;
            default:
                break;
        }
    }

    private void setStateText(TextView stateTv, MovieBean.RecordsBean bean) {
        switch ((bean.getState())) {
            case IEntity.STATE_WAIT:
                stateTv.setText("等待中");
                break;
            case IEntity.STATE_RUNNING:
                if (bean.getVideoSpeed() != null) {
                    stateTv.setText("已下载:" + bean.getVideoSize() + "," + bean.getVideoSpeed());
                }
                break;
            case IEntity.STATE_FAIL:
                stateTv.setText("未下载");
                break;
            case IEntity.STATE_PRE:
            case IEntity.STATE_POST_PRE:
                stateTv.setText("准备中");
                break;
            case IEntity.STATE_COMPLETE:
                stateTv.setText("下载完成");
                break;
            case IEntity.STATE_STOP:
                stateTv.setText("暂停中");
                break;

        }
    }

    public void notifyChanged(ArrayList<MovieBean.RecordsBean> list, MovieBean.RecordsBean bean) {
        for (int i = 0; i < getData().size(); i++) {
            if (TextUtils.equals(getItem(i).getVideoFullUrl(), bean.getVideoFullUrl())) {
                setTempData(list, bean, i);
                notifyItemChanged(i, "refresh");
            }
//            if (onNotifyListener != null) {
//                onNotifyListener.onNotify();
//            }
        }
    }

    @Override
    public void onBindViewHolder(@NonNull BaseViewHolder holder, int position, @NonNull List<Object> payloads) {
        if (payloads.isEmpty()) {
            super.onBindViewHolder(holder, position, payloads);
        } else {
            MovieBean.RecordsBean item = getItem(position);
            TextView tvSize = holder.getView(R.id.tv_size);
            TextView tvWatch = holder.getView(R.id.tv_is_watch);
            setProgressText(tvSize, item);
            setStateText(tvWatch, item);
            ImageView ivSelect = holder.getView(R.id.iv_select);
            if (item.isEdit()) {
                ivSelect.setVisibility(View.VISIBLE);
            } else {
                ivSelect.setVisibility(View.GONE);
            }
            ivSelect.setSelected(item.isSelected());

        }

    }

    private void setTempData(ArrayList<MovieBean.RecordsBean> list, MovieBean.RecordsBean bean, int i) {
        MovieBean.RecordsBean recordsBean = list.get(i);
        recordsBean.setVideoSpeed(bean.getVideoSize());
        recordsBean.setState(bean.getState());
        recordsBean.setProgress(bean.getProgress());
        recordsBean.setVideoSpeed(bean.getVideoSpeed());
        recordsBean.setLocalUrl(bean.getLocalUrl());
        recordsBean.setVideoSize(bean.getVideoSize());
    }


    public interface OnNotifyListener {
        void onNotify();
    }
}
