package com.hupu.tv.player.app.ui.adapter;


import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.softgarden.baselibrary.base.BaseActivity;
import com.hupu.tv.player.app.R;
import com.hupu.tv.player.app.bean.MovieBean;
import com.hupu.tv.player.app.utils.GlideUtils;

import java.util.List;


/**
 * @author by Dell
 * @date on 2020/6/15
 * @describe
 */
public class MineDownloadMoreFinishAdapter extends BaseQuickAdapter<MovieBean.RecordsBean, BaseViewHolder> {
    private BaseActivity baseActivity;
    private MovieBean.RecordsBean currentBean;
    public MineDownloadMoreFinishAdapter(int layoutResId, BaseActivity activity) {
        super(layoutResId);
        baseActivity = activity;
    }



    @Override
    protected void convert(BaseViewHolder helper, MovieBean.RecordsBean item) {
        ImageView ivSelect = helper.getView(R.id.iv_select);
        if (item.isEdit()) {
            ivSelect.setVisibility(View.VISIBLE);
        } else {
            ivSelect.setVisibility(View.GONE);
        }
        ivSelect.setSelected(item.isSelected());

        TextView tvWatch = helper.getView(R.id.tv_is_watch);
        String title;
        if (TextUtils.isEmpty(item.getVideoTitle())) {
            title = item.getMovieTitle();
        } else {
            title = item.getVideoTitle();
        }

        String imageUrl;
        if (TextUtils.isEmpty(item.getVideoEnCover())) {
            imageUrl = item.getMovieEnCover();
        } else {
            imageUrl = item.getVideoEnCover();
        }
//        helper.setText(R.id.tv_title, title).setText(R.id.tv_size,item.getVideoSize());
        helper.setText(R.id.tv_title, title);
//        if (item.isWatch()){
//            tvWatch.setText("已看");
//        }else {
//            tvWatch.setText("未看");
//        }
        GlideUtils.loadRoundCircleImageCenterCrop(baseActivity, imageUrl, helper.getView(R.id.iv_download), 4,R.mipmap.bg_place_holder_download);
        helper.addOnClickListener(R.id.iv_select);
//        setProgressText(pbDownload, tvSize, item);
//        setStateText(tvWatch, item);

    }

    @Override
    public void onBindViewHolder(@NonNull BaseViewHolder holder, int position, @NonNull List<Object> payloads) {
        if (payloads.isEmpty()){
            super.onBindViewHolder(holder, position, payloads);
        }else {
            MovieBean.RecordsBean item = getItem(position);
            ImageView ivSelect = holder.getView(R.id.iv_select);
            if (item.isEdit()) {
                ivSelect.setVisibility(View.VISIBLE);
            } else {
                ivSelect.setVisibility(View.GONE);
            }
            ivSelect.setSelected(item.isSelected());
        }

    }

    public void setEditStatus(boolean editStatus) {
        for (MovieBean.RecordsBean datum : this.getData()) {
            datum.setEdit(editStatus);
        }
        notifyItemRangeChanged(0,getData().size(),"refresh");
    }


}
