package com.hupu.tv.player.app.ui.adapter;

import android.widget.LinearLayout;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.softgarden.baselibrary.base.BaseFragment;
import com.softgarden.baselibrary.utils.RecyclerViewUtil;
import com.hupu.tv.player.app.R;
import com.hupu.tv.player.app.app.Constants;
import com.hupu.tv.player.app.bean.MovieBean;
import com.hupu.tv.player.app.utils.GlideUtils;

/**
 * @author by Dell
 * @date on 2020/6/15
 * @describe
 */
public class MineHistoryAdapter extends BaseQuickAdapter<MovieBean.RecordsBean, BaseViewHolder> {
    private BaseFragment baseFragment;
    public MineHistoryAdapter(int layoutResId, BaseFragment fragment) {
        super(layoutResId);
        baseFragment = fragment;
    }

    @Override
    protected void convert(BaseViewHolder helper, MovieBean.RecordsBean item) {
        LinearLayout.LayoutParams params = RecyclerViewUtil.INSTANCE.averageItem(baseFragment.getActivity(), 3, 36f, Constants.item_divider);
        helper.getView(R.id.ll_history).setLayoutParams(params);
        helper.setText(R.id.tv_title,item.getMovieTitle());
        GlideUtils.loadRoundCircleImageCenterCrop(baseFragment,item.getMovieEnCover(),helper.getView(R.id.iv_board),4);
    }
}
