package com.hupu.tv.player.app.ui.adapter;

import android.graphics.Paint;

import android.view.View;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.softgarden.baselibrary.base.BaseActivity;
import com.hupu.tv.player.app.R;
import com.hupu.tv.player.app.bean.PayVipTypeBean;

import java.util.List;

/**
 * @author by Dell
 * @date on 2020/6/15
 * @describe
 */
public class MineVipBuyAdapter extends BaseQuickAdapter<PayVipTypeBean, BaseViewHolder> {
    private BaseActivity baseActivity;

    public MineVipBuyAdapter(int layoutResId, @Nullable List<PayVipTypeBean> data, BaseActivity activity) {
        super(layoutResId, data);
        baseActivity = activity;
    }

    @Override
    protected void convert(BaseViewHolder helper, PayVipTypeBean item) {
        int saveMoney = (int) (item.getOriginalMoney() - item.getPayMoney());
        helper.setText(R.id.tv_name, item.getVipName())
                .setText(R.id.tv_price, String.valueOf(item.getPayMoney()))
                .setText(R.id.tv_origin_price, "¥" + item.getOriginalMoney())
                .setText(R.id.tv_save_money, "立省" +saveMoney + "元");
        helper.getView(R.id.ll_buy_vip).setSelected(item.isSelected());
        TextView tvHot = helper.getView(R.id.tv_hot);
        if (item.getVipName().equals("月卡")) {
            tvHot.setVisibility(View.VISIBLE);
        } else {
            tvHot.setVisibility(View.INVISIBLE);
        }
        TextView tvOriginPrice = helper.getView(R.id.tv_origin_price);
        tvOriginPrice.getPaint().setFlags(Paint.STRIKE_THRU_TEXT_FLAG);
        if (item.getOriginalMoney() > 0) {
            tvOriginPrice.setVisibility(View.VISIBLE);
        } else {
            tvOriginPrice.setVisibility(View.INVISIBLE);
        }
        TextView tvSaveMoney = helper.getView(R.id.tv_save_money);
        tvOriginPrice.getPaint().setFlags(Paint.STRIKE_THRU_TEXT_FLAG);
        //原价-现价>0
        if (saveMoney > 0) {
            tvSaveMoney.setVisibility(View.VISIBLE);
        } else {
            tvSaveMoney.setVisibility(View.INVISIBLE);
        }
    }

    @Override
    public void onBindViewHolder(@NonNull BaseViewHolder holder, int position, @NonNull List<Object> payloads) {
        if (payloads.size() ==0){
            super.onBindViewHolder(holder, position, payloads);
        }else {
            holder.getView(R.id.ll_buy_vip).setSelected(getData().get(position).isSelected());
        }
    }
}
