package com.hupu.tv.player.app.ui.adapter;

import android.graphics.Paint;

import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.hupu.tv.player.app.R;
import com.hupu.tv.player.app.app.App;
import com.hupu.tv.player.app.bean.PayVipTypeBean;

import java.util.List;

/**
 * @author by Dell
 * @date on 2020/6/15
 * @describe
 */
public class MineVipBuyNewAdapter extends BaseQuickAdapter<PayVipTypeBean, BaseViewHolder> {


    public MineVipBuyNewAdapter(int layoutResId, @Nullable List<PayVipTypeBean> data) {
        super(layoutResId, data);
    }

    @Override
    protected void convert(BaseViewHolder helper, PayVipTypeBean item) {
        TextView tvPrice = helper.getView(R.id.tv_price);
        TextView tvOriginPrice = helper.getView(R.id.tv_origin_price);
        TextView tvDescribe = helper.getView(R.id.tv_describe);
        TextView tvLabel = helper.getView(R.id.tv_money_label);
        ImageView ivBuy = helper.getView(R.id.iv_buy);
        String remark = TextUtils.isEmpty(item.getRemark3()) ? "" : item.getRemark3();
        String remark1 = TextUtils.isEmpty(item.getRemark1()) ? "" : item.getRemark1();
        String remark2 = TextUtils.isEmpty(item.getRemark2()) ? "" : item.getRemark2();
        helper.setText(R.id.tv_price, String.valueOf(item.getPayMoney()))
                .setText(R.id.tv_origin_price, "¥" + item.getOriginalMoney())
                .setText(R.id.tv_describe, remark1 +"   |   "+ remark2 + "\n" +remark );
        RelativeLayout root = helper.getView(R.id.rl_root);
        ImageView ivCover = helper.getView(R.id.iv_cover);
        root.setSelected(item.isSelected());

        switch (item.getVipName()) {
            case "年卡":
                tvPrice.setTextColor(App.Companion.getInstance().getResources().getColor(R.color.pay_year));
                tvLabel.setTextColor(App.Companion.getInstance().getResources().getColor(R.color.pay_year));
                tvOriginPrice.setTextColor(App.Companion.getInstance().getResources().getColor(R.color.pay_year_40));
                tvDescribe.setTextColor(App.Companion.getInstance().getResources().getColor(R.color.pay_year_80));
                ivBuy.setImageResource(R.mipmap.icon_buy_year);
//                ivCover.setImageResource(R.mipmap.bg_year);
                break;
            case "季卡":
                tvPrice.setTextColor(App.Companion.getInstance().getResources().getColor(R.color.pay_three_month));
                tvLabel.setTextColor(App.Companion.getInstance().getResources().getColor(R.color.pay_three_month));
                tvOriginPrice.setTextColor(App.Companion.getInstance().getResources().getColor(R.color.pay_three_month_40));
                tvDescribe.setTextColor(App.Companion.getInstance().getResources().getColor(R.color.pay_three_month_80));
                ivBuy.setImageResource(R.mipmap.icon_buy_three_month);
//                ivCover.setImageResource(R.mipmap.bg_three_month);
                break;
            case "月卡":
                tvPrice.setTextColor(App.Companion.getInstance().getResources().getColor(R.color.pay_month));
                tvLabel.setTextColor(App.Companion.getInstance().getResources().getColor(R.color.pay_month));
                tvOriginPrice.setTextColor(App.Companion.getInstance().getResources().getColor(R.color.pay_month_40));
                tvDescribe.setTextColor(App.Companion.getInstance().getResources().getColor(R.color.pay_month_80));
                ivBuy.setImageResource(R.mipmap.icon_buy_month);
//                ivCover.setImageResource(R.mipmap.bg_month);
                break;
            case "半年卡":
                tvPrice.setTextColor(App.Companion.getInstance().getResources().getColor(R.color.pay_half_year));
                tvLabel.setTextColor(App.Companion.getInstance().getResources().getColor(R.color.pay_half_year));
                tvOriginPrice.setTextColor(App.Companion.getInstance().getResources().getColor(R.color.pay_half_year_40));
                tvDescribe.setTextColor(App.Companion.getInstance().getResources().getColor(R.color.pay_half_year_80));
                ivBuy.setImageResource(R.mipmap.icon_buy_half_year);
//                ivCover.setImageResource(R.mipmap.bg_half_year);
                break;
            case "终身VIP":
                tvPrice.setTextColor(App.Companion.getInstance().getResources().getColor(R.color.white));
                tvLabel.setTextColor(App.Companion.getInstance().getResources().getColor(R.color.white));
                tvOriginPrice.setTextColor(App.Companion.getInstance().getResources().getColor(R.color.white_40));
                tvDescribe.setTextColor(App.Companion.getInstance().getResources().getColor(R.color.white_80));
                ivCover.setImageResource(R.mipmap.icon_buy_allways);
//                ivCover.setImageResource(R.mipmap.bg_allways);
                break;
        }
        tvOriginPrice.getPaint().setFlags(Paint.STRIKE_THRU_TEXT_FLAG);
        if (item.getOriginalMoney() > 0) {
            tvOriginPrice.setVisibility(View.VISIBLE);
        } else {
            tvOriginPrice.setVisibility(View.INVISIBLE);
        }

    }

    @Override
    public void onBindViewHolder(@NonNull BaseViewHolder holder, int position, @NonNull List<Object> payloads) {
        if (payloads.size() == 0) {
            super.onBindViewHolder(holder, position, payloads);
        } else {
            //暂时改为透明的了。选中效果仍在。
            holder.getView(R.id.rl_root).setSelected(getData().get(position).isSelected());
        }
    }
}
