package com.hupu.tv.player.app.ui.adapter;

import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.softgarden.baselibrary.base.BaseFragment;
import com.hupu.tv.player.app.R;
import com.hupu.tv.player.app.app.Constants;
import com.hupu.tv.player.app.bean.MovieBean;
import com.hupu.tv.player.app.utils.CommonUtils;
import com.hupu.tv.player.app.utils.GlideUtils;

/**
 * @author by Dell
 * @date on 2020/6/15
 * @describe
 */
public class MovieImageAdapter extends BaseQuickAdapter<MovieBean.RecordsBean, BaseViewHolder> {
    private BaseFragment baseFragment;

    public MovieImageAdapter(int layoutResId, BaseFragment fragment) {
        super(layoutResId);
        baseFragment = fragment;
    }

    @Override
    protected void convert(BaseViewHolder helper, MovieBean.RecordsBean item) {
        helper.setText(R.id.tv_title, item.getVideoTitle()).setText(R.id.tv_total_time, CommonUtils.formatTimeS(item.getVideoDuration()));
        helper.getView(R.id.tv_vip).setVisibility(View.VISIBLE);
        helper.getView(R.id.tv_total_time).setVisibility(View.VISIBLE);
        ImageView ivHome = helper.getView(R.id.iv_home);
        if (item.getTagId() == Constants.AD_MOVIE_ITEM) {
            //广告不显示VIP标志和时长
            helper.getView(R.id.tv_vip).setVisibility(View.GONE);
            helper.getView(R.id.tv_total_time).setVisibility(View.GONE);
            if (item.getVideoEnCover().endsWith(".gif")) {
                GlideUtils.loadRoundCircleImageCenterCropGif(baseFragment, item.getVideoEnCover(), ivHome, 4,R.drawable.shape_holder_place_movie);
            } else {
                GlideUtils.loadRoundCircleImageCenterCrop(baseFragment, item.getVideoEnCover(), ivHome, 4,R.drawable.shape_holder_place_movie);
            }
        } else {
            GlideUtils.loadRoundCircleImageCenterCrop(baseFragment, item.getVideoEnCover(), ivHome, 4,R.drawable.shape_holder_place_movie);
        }

        TextView tvTime = helper.getView(R.id.tv_time);
        if (CommonUtils.CompareDate(item.getCreateTime(), 15)) {
            tvTime.setText("15天前");
        } else if (CommonUtils.CompareDate(item.getCreateTime(), 5)) {
            tvTime.setText("5天前");
        } else {
            tvTime.setText("最新");
        }
    }

}
