package com.hupu.tv.player.app.ui.adapter;


import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.Nullable;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.hupu.tv.player.app.R;
import com.hupu.tv.player.app.app.App;
import com.hupu.tv.player.app.utils.CommonUtils;

import java.util.List;

/**
 * @author by Dell
 * @date on 2020/6/15
 * @describe
 */
public class NewSignAdapter extends BaseQuickAdapter<String, BaseViewHolder> {
    public NewSignAdapter(int layoutResId, @Nullable List<String> data) {
        super(layoutResId, data);

    }

    @Override
    protected void convert(BaseViewHolder helper, String item) {
        TextView tvSign = helper.getView(R.id.tv_sign);
        ImageView ivSign = helper.getView(R.id.iv_sign);
        int compare = item.compareTo(CommonUtils.getTime());
        if (compare <= 0) {
            ivSign.setImageResource(R.drawable.shape_already_sign);
        }
        if (compare > 0) {
            ivSign.setImageResource(R.drawable.shape_already_normal);
        }
//        if (helper.getPosition() == getData().size() -1){
//            ivSign.setImageResource(R.drawable.shape_already_sign_vip);
//        }
        tvSign.setText(String.format(App.Companion.getInstance().getString(R.string.string_day), helper.getPosition() + 1));
    }
}
