package com.hupu.tv.player.app.ui.adapter

import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import com.chad.library.adapter.base.BaseQuickAdapter
import com.chad.library.adapter.base.BaseViewHolder
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.bean.NewsListEntity
import com.hupu.tv.player.app.bean.NewsListTag
import com.hupu.tv.player.app.utils.GlideUtils
import com.softgarden.baselibrary.base.BaseActivity
import com.softgarden.baselibrary.base.BaseFragment
import com.softgarden.baselibrary.utils.ActivityManager

import com.softgarden.baselibrary.utils.RecyclerViewUtil

/**
 * @author by Dell
 * @date on 2020/6/15
 * @describe
 */
class NewsListAdapter : BaseQuickAdapter<NewsListEntity, BaseViewHolder>(R.layout.item_news) {
    override fun convert(helper: BaseViewHolder, item: NewsListEntity) {
        helper.setText(R.id.tv_title, item.title)
                .setText(R.id.tv_like_count, item.fakeLike.toString())
        GlideUtils.loadRoundCircleImageCenterCrop(helper.itemView, item.coverPicture, helper.getView(R.id.iv_cover),4, R.mipmap.bg_live_news_place_holder)
        val recyclerView = helper.getView<RecyclerView>(R.id.recycler_label)
        recyclerView.layoutManager = LinearLayoutManager(mContext,RecyclerView.HORIZONTAL,false)
        val newsLabelAdapter = NewsLabelAdapter(R.layout.item_news_label)
        if (recyclerView.itemDecorationCount==0){
            ActivityManager.instance.getCurrent<BaseActivity<*>>()?.let {
                RecyclerViewUtil.addItemDecoration(
                    it,recyclerView,R.color.transparent, 4,RecyclerView.HORIZONTAL)
            }
        }

        recyclerView.adapter = newsLabelAdapter
        item.tags?.let {
            if (it.size >3){
                val arrayListOf = arrayListOf<NewsListTag>()
                it[0]?.let { bean->
                    arrayListOf.add(bean)
                }
                it[1]?.let { bean->
                    arrayListOf.add(bean)
                }
                it[2]?.let { bean->
                    arrayListOf.add(bean)
                }
                newsLabelAdapter.setNewData(arrayListOf)
            }else{
                newsLabelAdapter.setNewData(it)
            }
        }
    }

}