package com.hupu.tv.player.app.ui.adapter;

import android.view.View;
import android.widget.ImageView;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.softgarden.baselibrary.base.BaseActivity;
import com.hupu.tv.player.app.R;
import com.hupu.tv.player.app.app.Constants;
import com.hupu.tv.player.app.bean.MovieBean;
import com.hupu.tv.player.app.utils.CommonUtils;
import com.hupu.tv.player.app.utils.GlideUtils;

/**
 * @author by Dell
 * @date on 2020/6/15
 * @describe
 */
public class NormalLayoutSpecialAdapter extends BaseQuickAdapter<MovieBean.RecordsBean, BaseViewHolder> {
    private BaseActivity baseActivity;
    public NormalLayoutSpecialAdapter(int layoutResId, BaseActivity activity) {
        super(layoutResId);
        baseActivity = activity;
    }

    @Override
    protected void convert(BaseViewHolder helper, MovieBean.RecordsBean item) {
        helper.setText(R.id.tv_title, item.getVideoTitle())
                .setText(R.id.tv_play_time, CommonUtils.formatTimeS(item.getVideoDuration()))
                .setText(R.id.tv_like_count,String.valueOf(item.getVideoLike()))
                .setText(R.id.tv_see_count,String.valueOf(item.getVideoPlayNum()));
        helper.getView(R.id.tv_play_time).setVisibility(View.VISIBLE);
        ImageView ivCover = helper.getView(R.id.iv_cover);
        if (item.getTagId() == Constants.AD_MOVIE_ITEM) {
            //广告不显示VIP标志和时长
            helper.getView(R.id.tv_play_time).setVisibility(View.GONE);
            if (item.getVideoEnCover().endsWith(".gif")) {
                GlideUtils.loadRoundCircleImageCenterCropGif(baseActivity, item.getVideoEnCover(), ivCover, 3);
            } else {
                GlideUtils.loadRoundCircleImageCenterCrop(baseActivity,  item.getVideoEnCover(), ivCover, 3);
            }
        } else {
            GlideUtils.loadRoundCircleImageCenterCrop(baseActivity, item.getTransVideoCover(), ivCover, 3);
        }
//        .setText(R.id.tv_describe,item.getDescribe());
//        GlideUtils.loadRoundCircleImageCenterCrop(baseActivity,
//                item.getVideoEnCover(),
//                helper.getView(R.id.iv_cover),4,R.drawable.shape_holder_place_recommend);
//
    }
}
