package com.hupu.tv.player.app.ui.adapter;



import androidx.annotation.Nullable;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.softgarden.baselibrary.base.BaseActivity;
import com.hupu.tv.player.app.R;
import com.hupu.tv.player.app.bean.PayTypeBean;
import com.hupu.tv.player.app.utils.GlideUtils;

import java.util.List;

/**
 * @author by Dell
 * @date on 2020/6/15
 * @describe
 */
public class PayInfoAdapter extends BaseQuickAdapter<PayTypeBean, BaseViewHolder> {
    private BaseActivity baseActivity;
    public PayInfoAdapter(int layoutResId, @Nullable List<PayTypeBean> data, BaseActivity activity) {
        super(layoutResId, data);
        baseActivity = activity;
    }

    @Override
    protected void convert(BaseViewHolder helper, PayTypeBean item) {
        helper.setText(R.id.tv_pay_name,item.getPayChannelNameCn());
        GlideUtils.loadImage(baseActivity,item.getIconUrl(),helper.getView(R.id.iv_pay_type));
    }
}
