package com.hupu.tv.player.app.ui.adapter;

import android.content.Intent;
import android.os.Build;

import android.widget.ImageView;

import androidx.annotation.RequiresApi;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.softgarden.baselibrary.base.BaseActivity;
import com.hupu.lds.ui.webView.WebViewActivity;
import com.hupu.tv.player.app.R;
import com.hupu.tv.player.app.app.Constants;
import com.hupu.tv.player.app.bean.AdBean;
import com.hupu.tv.player.app.utils.GlideUtils;

import java.util.List;

/**
 * @author by Dell
 * @date on 2020/6/15
 * @describe
 */
public class PlayDetailAdAdapter extends BaseQuickAdapter<AdBean, BaseViewHolder> {
    private BaseActivity baseActivity;
    public PlayDetailAdAdapter(int layoutResId, List<AdBean> list,BaseActivity activity) {
        super(layoutResId, list);
        baseActivity = activity;
    }

    @RequiresApi(api = Build.VERSION_CODES.M)
    @Override
    protected void convert(BaseViewHolder helper, AdBean item) {
        ImageView view = helper.getView(R.id.iv_detail_ad);
        if (item.getPicFullPath().endsWith(".gif")) {
            GlideUtils.loadImageGif(baseActivity, item.getPicFullPath(), view);
        } else {
            GlideUtils.loadImage(baseActivity, item.getPicFullPath(), view);
        }
        view.setOnClickListener(v -> {
            Intent intent = new Intent(baseActivity, WebViewActivity.class);
            intent.putExtra(Constants.H5_URL,item.getAdUrl());
            baseActivity.startActivity(intent);
        });
    }
}
