package com.hupu.tv.player.app.ui.adapter

import android.view.View
import android.widget.TextView
import androidx.fragment.app.Fragment
import com.chad.library.adapter.base.BaseQuickAdapter
import com.chad.library.adapter.base.BaseViewHolder
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.bean.MovieDetailBean.ActorVOsListBean
import com.hupu.tv.player.app.bean.RedListData
import com.hupu.tv.player.app.utils.GlideUtils
import com.softgarden.baselibrary.base.BaseActivity

/**
 * @author by Dell
 * @date on 2020/6/15
 * @describe
 */
class RedListAdapter(layoutResId: Int, private val fragment: Fragment) :
    BaseQuickAdapter<RedListData, BaseViewHolder>(layoutResId) {
    override fun convert(helper: BaseViewHolder, item: RedListData) {
        GlideUtils.loadAvatar(fragment, item.anchorIcon, helper.getView(R.id.iv_avatar))
        helper.setText(R.id.tv_name, item.anchorName)
            .setText(R.id.tv_continue_red, "${item.continuousWin}连胜")
            .setText(R.id.tv_rate_tag, "${item.sum}中${item.wins}")
            .setText(R.id.tv_rate, "${item.sum}中${item.wins}")
            .setText(
                R.id.tv_win_rate,
                "${item.wins.toFloat().div(item.sum.toFloat()).times(100).toInt()}%"
            )
            .setText(R.id.tv_title, item.title)
            .setText(R.id.tv_time, item.releaseTime)
            .getView<TextView>(R.id.tv_type).apply {
                visibility = View.GONE
                item.tagName?.let {
                    if (it.isNotEmpty()) {
                        visibility = View.VISIBLE
                        text = it[0]
                    }
                }
            }
    }
}