package com.hupu.tv.player.app.ui.adapter;

import android.view.View;


import com.chad.library.adapter.base.BaseMultiItemQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.softgarden.baselibrary.base.BaseActivity;
import com.hupu.tv.player.app.R;
import com.hupu.tv.player.app.bean.MovieBean;
import com.hupu.tv.player.app.utils.GlideUtils;

import java.util.List;

/**
 * @author by Dell
 * @date on 2020/6/15
 * @describe
 */
public class SeeMoreHistoryAdapter extends BaseMultiItemQuickAdapter<MovieBean.RecordsBean, BaseViewHolder> {
    private BaseActivity baseActivity;

    public SeeMoreHistoryAdapter(List<MovieBean.RecordsBean> list, BaseActivity activity) {
        super(list);
        addItemType(MovieBean.RecordsBean.TYPE_SHOW_HOT,R.layout.item_more);
        addItemType(MovieBean.RecordsBean.TYPE_SHOW_NORMAL,R.layout.item_see_more);
        baseActivity = activity;
    }

    @Override
    protected void convert(BaseViewHolder helper, MovieBean.RecordsBean item) {
        switch (helper.getItemViewType()){
            case MovieBean.RecordsBean.TYPE_SHOW_HOT:
                helper.setText(R.id.tv_more,"更多");
                break;
            case MovieBean.RecordsBean.TYPE_SHOW_NORMAL:
                View view = helper.getView(R.id.ll_coin);
                if (item.getBuyGoldCoin() == 0){
                    view.setVisibility(View.INVISIBLE);
                }else {
                    view.setVisibility(View.VISIBLE);
                }
                helper.setText(R.id.tv_title, item.getMovieTitle())
                        .setText(R.id.tv_coin,String.valueOf(item.getBuyGoldCoin()));
                GlideUtils.loadRoundCircleImageCenterCrop(baseActivity,
                        item.getMovieEnCover(),
                        helper.getView(R.id.iv_cover), 4,R.mipmap.bg_place_holder_history_collection);
                break;
        }

    }
}
