package com.hupu.tv.player.app.ui.adapter;

import android.view.View;
import android.widget.ImageView;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.softgarden.baselibrary.base.BaseFragment;
import com.hupu.tv.player.app.R;
import com.hupu.tv.player.app.app.Constants;
import com.hupu.tv.player.app.bean.StarBean;
import com.hupu.tv.player.app.utils.GlideUtils;

/**
 * @author by Dell
 * @date on 2020/6/15
 * @describe
 */
public class StarAdapter extends BaseQuickAdapter<StarBean.ListBean, BaseViewHolder> {
    private BaseFragment baseFragment;
    private String type;

    public StarAdapter(int layoutResId, BaseFragment fragment, String type) {
        super(layoutResId);
        baseFragment = fragment;
        this.type = type;
    }

    @Override
    protected void convert(BaseViewHolder helper, StarBean.ListBean item) {
        if (type.equals(Constants.HOT_STAR)) {
            ImageView ivLevel = helper.getView(R.id.iv_level);
            ivLevel.setVisibility(View.VISIBLE);
            switch (helper.getPosition()) {
                case 0:
                    ivLevel.setImageDrawable(baseFragment.getResources().getDrawable(R.mipmap.icon_level_1));
                    break;
                case 1:
                    ivLevel.setImageDrawable(baseFragment.getResources().getDrawable(R.mipmap.icon_level_2));
                    break;
                case 2:
                    ivLevel.setImageDrawable(baseFragment.getResources().getDrawable(R.mipmap.icon_level_3));
                    break;
                default:
                    ivLevel.setVisibility(View.GONE);
                    break;
            }
        }
        GlideUtils.loadCirclePic(baseFragment, item.getPicPath(), helper.getView(R.id.iv_actor));
        helper.setText(R.id.tv_name, item.getStartName());
    }
}
