package com.hupu.tv.player.app.ui.adapter;

import com.chad.library.adapter.base.BaseMultiItemQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.softgarden.baselibrary.base.BaseFragment;
import com.hupu.tv.player.app.R;
import com.hupu.tv.player.app.app.Constants;
import com.hupu.tv.player.app.bean.StarBean;
import com.hupu.tv.player.app.utils.GlideUtils;

import java.util.List;

/**
 * @author by Dell
 * @date on 2020/6/15
 * @describe
 */
public class StarAllAdapter extends BaseMultiItemQuickAdapter<StarBean.ListBean, BaseViewHolder> {
    private BaseFragment baseFragment;


    public StarAllAdapter(BaseFragment fragment, List<StarBean.ListBean> listBeans) {
        super(listBeans);
        addItemType(StarBean.ListBean.TITLE, R.layout.item_star_title);
        addItemType(StarBean.ListBean.CONTENT, R.layout.item_star_image);
        baseFragment = fragment;

    }

    @Override
    protected void convert(BaseViewHolder helper, StarBean.ListBean item) {

        String type = item.getType();
//        if (type.equals(Constants.HOT_STAR)) {
//            ImageView ivLevel = helper.getView(R.id.iv_level);
//            ivLevel.setVisibility(View.VISIBLE);
//        }
        if (helper.getItemViewType() == StarBean.ListBean.CONTENT) {
            GlideUtils.loadCirclePic(baseFragment, item.getPicPath(), helper.getView(R.id.iv_actor));
            helper.setText(R.id.tv_name, item.getStartName());
        } else {
            if (type.equals(Constants.HOT_STAR)) {
                helper.setText(R.id.tv_index, "热门女优");
            } else {
                helper.setText(R.id.tv_index, type);
            }
        }
    }
}
