package com.hupu.tv.player.app.ui.adapter;

import android.widget.ImageView;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.softgarden.baselibrary.base.BaseActivity;
import com.hupu.tv.player.app.R;
import com.hupu.tv.player.app.bean.IconBean;
import com.hupu.tv.player.app.utils.CommonUtils;
import com.hupu.tv.player.app.utils.GlideUtils;

import java.util.List;

/**
 * @author by Dell
 * @date on 2020/6/15
 * @describe
 */
public class TitTokIconAdapter extends BaseQuickAdapter<IconBean, BaseViewHolder> {
    private BaseActivity baseActivity;

    public TitTokIconAdapter(int layoutResId, BaseActivity activity, List<IconBean> data) {
        super(layoutResId, data);
        baseActivity = activity;
    }

    @Override
    protected void convert(BaseViewHolder helper, IconBean item) {
        ImageView ivAd = helper.getView(R.id.iv_ad);
        GlideUtils.loadCirclePic(baseActivity, item.getPicFullPath(), ivAd);
        ivAd.setOnClickListener(v -> baseActivity.startActivity(CommonUtils.toWeb(item.getAdUrl())));


    }
}
