package com.hupu.tv.player.app.ui.adapter

import androidx.recyclerview.widget.RecyclerView
import android.text.TextUtils
import android.view.View
import android.widget.ImageView
import android.widget.RelativeLayout
import android.widget.TextView
import androidx.fragment.app.FragmentActivity
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.OrientationHelper
import com.bumptech.glide.Glide
import com.bumptech.glide.ListPreloader
import com.bumptech.glide.RequestBuilder
import com.chad.library.adapter.base.BaseQuickAdapter
import com.chad.library.adapter.base.BaseViewHolder
import com.softgarden.baselibrary.base.BaseActivity
import com.softgarden.baselibrary.utils.RecyclerViewUtil
import com.softgarden.baselibrary.utils.SPUtil
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.bean.IconBean
import com.hupu.tv.player.app.bean.MovieBean.RecordsBean
import com.hupu.tv.player.app.ui.activity.ShareActivity
import com.hupu.tv.player.app.utils.GlideUtils
import com.hupu.tv.player.app.widget.CustomLayoutGSYVideoPlayer
import me.jessyan.autosize.utils.LogUtils


/**
 * @author by Dell
 * @date on 2020/6/15
 * @describe
 */
class VideoAdapter(layoutResId: Int, private val baseActivity: BaseActivity<*>?) : BaseQuickAdapter<RecordsBean, BaseViewHolder>(layoutResId)
        , ListPreloader.PreloadModelProvider<RecordsBean> {
    private var player: CustomLayoutGSYVideoPlayer? = null
    private var onPlayerListener: OnPlayerListener? = null

    fun setOnPlayerListener(onPlayerListener: OnPlayerListener) {
        this.onPlayerListener = onPlayerListener
    }

    override fun convert(helper: BaseViewHolder, item: RecordsBean) {
        //播放器
        player = helper.getView(R.id.player)
        val tvAdCover = helper.getView<TextView>(R.id.tv_ad_cover)
        tvAdCover.visibility = View.GONE
        LogUtils.e("viewPagerLayout adapter :${helper.position},${item.id}")
        //封面
        if (item.videoEnCover.endsWith(".gif")) {
            GlideUtils.loadImageGif(baseActivity, item.videoEnCover, helper.getView(R.id.iv_cover), 0)
        } else {
            GlideUtils.loadImageNoCenter(baseActivity, item.videoEnCover, helper.getView(R.id.iv_cover), 0)
//            Glide.with(baseActivity as AppCompatActivity)
//                    .setDefaultRequestOptions(
//                            RequestOptions()
//                                    .frame(4000000)
//                                    .centerCrop()
//                                    .error( R.drawable.shape_holder_place_tiktok) //可以忽略
//                                    .placeholder( R.drawable.shape_holder_place_tiktok) //可以忽略
//                    )
//                    .load(item.videoFullUrl)
//                    .into(helper.getView<ImageView>(R.id.iv_cover))
        }

        //播放器加载地址
        //图片广告则不用加载
        val ivFull: ImageView = helper.getView(R.id.iv_full)


        if (item.tagId != Constants.AD_MOVIE_ITEM_PICTURE) {
            val url = if (!TextUtils.isEmpty(item.previewMovieUrl)) {
//                ToastUtil.s("preview")
                ivFull.visibility = View.VISIBLE
                item.isPlayFullUrl = false
                item.previewMovieUrl
            } else {
//                ToastUtil.s("full")
                item.isPlayFullUrl = true
                ivFull.visibility = View.GONE
                item.videoFullUrl
            }
            player?.setUpLazy(url, true, null, null, null)
            player?.isLooping = true
        }

//        player?.setUpLazy("https://xbf.robbieguo.com//5bba45bcd96896f85f573177cfe9b45c/v.m3u8?s=2e78ab43d0fd1deefadcde98d6a25894&t=1603373638", true, null, null, null)
//        player?.setUpLazy("https://bf.robbieguo.com//e4b00d96cf42e2928694dabf602ab6ff/v.m3u8?s=c27032257183d367266c6b7a1e0b2eeb&t=1603803545", true, null, null, null)
//        player?.setUpLazy("http://agasound.cn/play/short/202010271619/202010271619.m3u8", true, null, null, null)
        //标题，点赞数，分享数
        helper.setText(R.id.tv_content, item.videoTitle)
                .setText(R.id.tv_like, setNumberData(item.videoCollection))
//                .setText(R.id.tv_share, setNumberData(item.videoLike))
        //头像
        val ivHide = helper.getView<ImageView>(R.id.iv_hide)
        val view = helper.getView<RelativeLayout>(R.id.rl_layout)
        view.visibility = View.VISIBLE
        ivHide.isSelected = false
        ivHide.setOnClickListener {
            ivHide.isSelected = !ivHide.isSelected
            if (view.visibility == View.VISIBLE) {
                view.visibility = View.GONE
            } else {
                view.visibility = View.VISIBLE
            }
        }
        val ivHead = helper.getView<ImageView>(R.id.iv_head)
        ivHead.visibility = View.INVISIBLE
        GlideUtils.loadCirclePic(baseActivity, item.starId, ivHead)
        if (item.starImage != 0) {
            ivHead.visibility= View.VISIBLE
            ivHead.setOnClickListener {
//                val intent = Intent(baseActivity, StarDetailActivity::class.java)
//                intent.putExtra(Constants.STAR_ID, item.starImage)
//                intent.putExtra(Constants.STAR_TYPE, Constants.STAR_TYPE_TIKTOK)
//                baseActivity?.startActivity(intent)
            }
        }

        //活动广告

        val tikTokList = SPUtil.getSerializableObject<ArrayList<IconBean>>(Constants.TIK_TOK_AD)
                ?: arrayListOf()
        val recycleTik = helper.getView<RecyclerView>(R.id.recycler_tik)
        recycleTik.layoutManager = LinearLayoutManager(baseActivity)
        val tikAdapter = TitTokIconAdapter(R.layout.item_tit_tok, baseActivity, tikTokList)
        recycleTik.adapter = tikAdapter
        if (recycleTik.itemDecorationCount == 0) {
            baseActivity?.let {
                RecyclerViewUtil.addItemDecoration(it, recycleTik, R.color.transparent, 10)
            }

        }


        //标签的recyclerView
        val recyclerViewLabel = helper.getView<RecyclerView>(R.id.recycler_label)
        val layoutManagerLabel = LinearLayoutManager(baseActivity, RecyclerView.HORIZONTAL, false)
        recyclerViewLabel.layoutManager = RecyclerViewUtil.nestedScrollNoFluent(recyclerViewLabel, layoutManagerLabel)
        baseActivity?.let {
            if (recyclerViewLabel.itemDecorationCount == 0) {
                RecyclerViewUtil.addItemDecoration(it, recyclerViewLabel, R.color.transparent, Constants.item_divider, OrientationHelper.HORIZONTAL)
            }
        }
        val toMutableList = item.clist
        val labelAdapter = TikTokLabelAdapter(R.layout.item_label, toMutableList)
        labelAdapter.setOnItemChildClickListener { adapter, view, position ->
            if (view.id == R.id.tv_label) {
                val bean = adapter.getItem(position) as RecordsBean.StarInfoBean
//                val intent = Intent(baseActivity, MoreTagActivity::class.java)
//                intent.putExtra(Constants.SEARCH_KEY, bean.cid)
//                intent.putExtra(Constants.SEARCH_TITLE, bean.cname)
//                intent.putExtra(Constants.TAG_TYPE, Constants.TAG_TYPE_MOVIE)
//                intent.putExtra(CategoryBean.ID, bean.cid)
//                baseActivity?.startActivity(intent)
            }
        }
        recyclerViewLabel.adapter = labelAdapter
        //点赞的图标
        val ivLike = helper.getView<ImageView>(R.id.iv_like)
        //是否点赞
        ivLike.isSelected = item.isCollection == 1
        ivLike.setOnClickListener {
            if (ivLike.isSelected) {
                item.isCollection = 0
                ivLike.isSelected = false
            } else if (!ivLike.isSelected) {
                item.isCollection = 1
                ivLike.isSelected = true
            }
            onPlayerListener?.onLike(item.id, helper.position)
        }
        //分享的点击事件
        helper.getView<ImageView>(R.id.iv_share).setOnClickListener {
            baseActivity?.startActivity(ShareActivity::class.java)
        }
        //点赞监听
        helper.addOnClickListener(R.id.iv_full)
    }

    private fun setNumberData(number: Int?): String? {
        var collection = "0"
        collection = number?.toString() ?: "0"
        number?.let {
            if (it > 10000) {
                collection = String.format("%.1f", it.toFloat() / 10000) + "W"
                return collection
            }
        }
        return collection
    }

    public interface OnPlayerListener {

        fun onLike(movieId: Int, position: Int)


        fun onFinish()
    }


    fun fullVideo(videoUrl: String) {
        player?.setUp(videoUrl, true, null, null, null)
    }

    override fun getPreloadItems(position: Int): MutableList<RecordsBean> {
        if (data.size == 0) {
            return arrayListOf()
        }
        if (position + 1 > data.size) {
            return data.subList(position - 1, position)
        }
        return data.subList(position, position + 1)
    }

    override fun getPreloadRequestBuilder(item: RecordsBean): RequestBuilder<*>? {
        return Glide.with(baseActivity as FragmentActivity).load(item.videoEnCover)
    }

}