package com.hupu.tv.player.app.ui.adapter;

import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.style.ForegroundColorSpan;
import android.widget.TextView;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.softgarden.baselibrary.utils.ToastUtil;
import com.hupu.tv.player.app.R;
import com.hupu.tv.player.app.app.App;
import com.hupu.tv.player.app.app.Constants;
import com.hupu.tv.player.app.bean.WalletDetailBean;
import com.hupu.tv.player.app.utils.CommonUtils;

/**
 * @author by Dell
 * @date on 2020/6/15
 * @describe
 */
public class WalletListAdapter extends BaseQuickAdapter<WalletDetailBean.DataListBean, BaseViewHolder> {


    public WalletListAdapter(int layoutResId) {
        super(layoutResId);

    }

    @Override
    protected void convert(BaseViewHolder helper, WalletDetailBean.DataListBean item) {
        int color = 0;
        String status = "";
        switch (item.getPayStatus()) {
            case Constants.PAY_COIN_FAIL:
                status = Constants.PAY_COIN_FAIL_TEXT;
                color = R.color.pay_fail;
                break;
            case Constants.PAY_COIN_ING:
                status = Constants.PAY_COIN_ING_TEXT;
                color = R.color.pay_deal;
                break;
            case Constants.PAY_COIN_SUCCESS:
                status = Constants.PAY_COIN_SUCCESS_TEXT;
                color = R.color.pay_success;
                break;
            default:
                break;
        }
        TextView tvOrder = helper.getView(R.id.tv_order_num);
        TextView tvStatus = helper.getView(R.id.tv_status);
        tvStatus.setTextColor(App.Companion.getInstance().getResources().getColor(color));
        tvOrder.setOnClickListener(v -> {
            CommonUtils.INSTANCE.copy(item.getOrderNo());
            ToastUtil.Companion.s("复制成功");
        });
        String orderNo = String.format(App.Companion.getInstance().getString(R.string.string_wallet_order_number), item.getOrderNo());
        SpannableStringBuilder style = new SpannableStringBuilder(orderNo);
        style.setSpan( new ForegroundColorSpan(App.Companion.getInstance().getResources().getColor(R.color.bg_red_2)),orderNo.length()-2,orderNo.length(),Spannable.SPAN_EXCLUSIVE_EXCLUSIVE);
        helper.setText(R.id.tv_amount, String.format(App.Companion.getInstance().getString(R.string.string_wallet_order_count), item.getAmount()))
                .setText(R.id.tv_status, status)
                .setText(R.id.tv_order_num,style)
                .setText(R.id.tv_buy_time, String.format(App.Companion.getInstance().getString(R.string.string_wallet_order_date),item.getBuyTime()));
    }
}
