package com.hupu.tv.player.app.ui.adapter;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.hupu.tv.player.app.R;
import com.hupu.tv.player.app.app.App;
import com.hupu.tv.player.app.app.Constants;
import com.hupu.tv.player.app.bean.WithdrawListBean;

/**
 * @author by Dell
 * @date on 2020/6/15
 * @describe
 */
public class WithDrawListAdapter extends BaseQuickAdapter<WithdrawListBean, BaseViewHolder> {


    public WithDrawListAdapter(int layoutResId) {
        super(layoutResId);

    }

    @Override
    protected void convert(BaseViewHolder helper, WithdrawListBean item) {
        String status = "";
        switch (item.getStatus()) {
            case Constants.WITHDRAW_FAIL:
                status = mContext.getString(R.string.string_withdraw_fail);
                break;
            case Constants.WITHDRAW_ING:
                status = mContext.getString(R.string.string_withdrawing);
                break;
            case Constants.WITHDRAW_DEAL:
                status = mContext.getString(R.string.string_withdraw_deal);
                break;
            case Constants.WITHDRAW_SUCCESS:
                status = mContext.getString(R.string.string_withdraw_success);
                break;
            default:
                break;
        }
        helper.setText(R.id.tv_amount, String.format(App.Companion.getInstance().getString(R.string.string_money_label), String.valueOf(item.getWithdrawAmt())))
                .setText(R.id.tv_status, status)
                .setText(R.id.tv_time, item.getCreateTime());
    }
}
