package com.hupu.tv.player.app.ui.contact

import com.softgarden.baselibrary.base.IBaseDisplay
import com.hupu.tv.player.app.bean.*

/**
 * @author by Dell
 * @date on 2020/6/24
 * @describe
 */
interface PlayerDetailContact {
    interface Display : IBaseDisplay {
        fun onRequestMoveDetail(bean:MovieDetailBean?)
        fun onRequestRecommend(data: MovieBean?)
        fun onLikeRefresh(count:Int)
        fun onCollectionRefresh(count:Int)
        fun onShareMovie(url:String?)
        fun onDownloadMovie()
        fun onPlayerMovie()
        fun onRefreshMovieDetail(bean:MovieDetailBean?)
        fun onShareMineInfo()
        fun onWinnerRequest(list:List<String>?)
        fun onLikeMovie(list:ArrayList<MovieBean.RecordsBean>?)
        fun onBuyResult()
    }

    interface Presenter {
        fun getLike()
        fun getMovieDetail(movieId: Int?)
        fun getRecommend()
        fun moviePlay(movieId:Int?)
        fun clickLike(movieId: Int?)
        fun clickCollect(movieId: Int?)
        fun shareMovie()
        fun downloadMovie(movieId: Int?)
        fun dealDownloadWatch(bean:MovieBean.RecordsBean)
        fun refreshUserBean()
        fun goBindPhone()
        fun getRefreshMovieDetail(movieId:Int?)
        fun shareMineInfo()
        fun goShare()
        fun goVip()
        fun getWinnerList()
        fun buyGold(movieId:Int)
    }
}