package com.hupu.tv.player.app.ui.fragment

import android.content.Context
import android.os.Bundle
import androidx.recyclerview.widget.LinearLayoutManager
import com.softgarden.baselibrary.base.BaseActivity
import com.softgarden.baselibrary.utils.RecyclerViewUtil
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.base.RefreshFragment
import com.hupu.tv.player.app.bean.RoomInfoBean
import com.hupu.tv.player.app.ui.adapter.MatchCollectionAdapter
import com.hupu.tv.player.app.ui.contact.BasketBallCollectionFragmentContact
import com.hupu.tv.player.app.ui.presenter.BasketBallCollectionFragmentPresenter


/**
 * @author by Dell
 * @date on 2020/6/15
 * @describe
 */
class BasketBallCollectionFragment : RefreshFragment<BasketBallCollectionFragmentPresenter>(), BasketBallCollectionFragmentContact.Display {
    private var roomid = ""
    private lateinit var adapter: MatchCollectionAdapter
    override val layoutId: Int
        get() = R.layout.fragment_collection

    override val baseActivity: BaseActivity<*>?
        get() = activity as BaseActivity<*>

    override fun onRequestRoomInfo(bean: RoomInfoBean?) {
    }


    override val ctx: Context?
        get() = super.ctx

    override fun initEventAndData() {
        initRefreshLayout()
        initRecyclerView()
        initAdapter()
        arguments?.let {
            roomid = it.getString(Constants.ROOM_ID, "")
        }

    }

    private fun initAdapter() {
        adapter = MatchCollectionAdapter(R.layout.item_match_collection, this)
        mRecyclerView?.layoutManager = LinearLayoutManager(requireContext())
        mRecyclerView?.let {
            RecyclerViewUtil.addItemDecoration(requireActivity(), it, R.color.view_color, 1f)
        }
        mRecyclerView?.adapter = adapter
//        adapter.setNewData(loadFakeData())
        setLoadData(adapter,arrayListOf<String>())
    }
    override fun lazyLoad() {
        presenter?.getRoomInfo(roomid)
        mRecyclerView?.postDelayed({
            finishRefresh()
        }, 3000)
    }


    companion object {
        @JvmStatic
        fun newInstance(id: String): BasketBallCollectionFragment {
            val args = Bundle()
            val fragment = BasketBallCollectionFragment()
            args.putString(Constants.ROOM_ID, id)
            fragment.arguments = args
            return fragment
        }
    }


}