package com.hupu.tv.player.app.ui.fragment

import android.content.Context
import android.os.Bundle
import android.view.View
import androidx.recyclerview.widget.LinearLayoutManager
import com.softgarden.baselibrary.base.BaseActivity
import com.softgarden.baselibrary.utils.RecyclerViewUtil
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.base.RefreshFragment
import com.hupu.tv.player.app.base.RefreshVP2Fragment
import com.hupu.tv.player.app.bean.PlayerListEntity
import com.hupu.tv.player.app.bean.RoomInfoBean
import com.hupu.tv.player.app.ui.adapter.MainPlayerAdapter
import com.hupu.tv.player.app.ui.contact.BasketBallPlayerFragmentContact
import com.hupu.tv.player.app.ui.presenter.BasketBallPlayerFragmentPresenter
import kotlinx.android.synthetic.main.fragment_match_player.*
import kotlinx.android.synthetic.main.layout_empty.*


/**
 * @author by Dell
 * @date on 2020/6/15
 * @describe
 */
class BasketBallPlayerFragment : RefreshVP2Fragment<BasketBallPlayerFragmentPresenter>(), BasketBallPlayerFragmentContact.Display {
    private var roomid = ""
    private lateinit var adapter: MainPlayerAdapter
    private lateinit var awayAdapter: MainPlayerAdapter
    private var homePlayList:ArrayList<PlayerListEntity?>? = null
    private var awayPlayList:ArrayList<PlayerListEntity?>? =null

    override val layoutId: Int
        get() = R.layout.fragment_match_player

    override val baseActivity: BaseActivity<*>?
        get() = activity as BaseActivity<*>

    override fun onRequestRoomInfo(bean: RoomInfoBean?) {

    }


    override val ctx: Context?
        get() = super.ctx

    override fun initEventAndData() {

        arguments?.let {
            roomid = it.getString(Constants.ROOM_ID, "")
            homePlayList = it.getSerializable(Constants.HOME_TEAM) as? ArrayList<PlayerListEntity?>?
            awayPlayList = it.getSerializable(Constants.AWAY_TEAM) as? ArrayList<PlayerListEntity?>?
            tv_team_name.text = it.getString(Constants.HOME_TEAM_NAME)
            tv_team_away_name.text = it.getString(Constants.AWAY_TEAM_NAME)
        }

        if (homePlayList.isNullOrEmpty() && awayPlayList.isNullOrEmpty()) {
            nestedScroll.visibility = View.GONE
            ll_empty.visibility = View.VISIBLE
        } else {
            nestedScroll.visibility = View.VISIBLE
            ll_empty.visibility = View.GONE
            initRefreshLayout()
            initRecyclerView()
            initHomeAdapter()
            initAwayRecyclerView()
        }


    }

    private fun initHomeAdapter() {
        mRecyclerView?.let {
            it.layoutManager = RecyclerViewUtil.nestedScrollNoFluent(it, LinearLayoutManager(activity))
            RecyclerViewUtil.addItemDecoration(requireActivity(), it, R.color.view_color, 1f)
        }
        adapter = MainPlayerAdapter(R.layout.item_match_player)
        if (!homePlayList.isNullOrEmpty()) {
            adapter.addHeaderView(View.inflate(requireContext(), R.layout.item_match_player_title, null))
        }
        mRecyclerView?.adapter = adapter
        adapter.setNewData(homePlayList)
    }

    private fun initAwayRecyclerView() {
        mRecyclerView_away?.let {
            it.layoutManager = RecyclerViewUtil.nestedScrollNoFluent(it, LinearLayoutManager(activity))
            RecyclerViewUtil.addItemDecoration(requireActivity(), it, R.color.view_color, 1f)
        }

        awayAdapter = MainPlayerAdapter(R.layout.item_match_player)
        if (!awayPlayList.isNullOrEmpty()) {
            awayAdapter.addHeaderView(View.inflate(requireContext(), R.layout.item_match_player_title, null))
        }

        mRecyclerView_away?.adapter = awayAdapter
        awayAdapter.setNewData(awayPlayList)
    }


    private fun loadFakeData(): MutableList<String>? {
        val arrayListOf = arrayListOf<String>()
        repeat(9) {
            arrayListOf.add("1")
        }
        return arrayListOf
    }


    override fun lazyLoad() {
        presenter?.getRoomInfo(roomid)
//        presenter?.getBaseketballInfo(roomid)
        mRecyclerView?.postDelayed({
            finishRefresh()
        }, 3000)
    }


    companion object {
        @JvmStatic
        fun newInstance(id: String,
                        homeName: String,
                        awayName: String,
                        homePlayList: ArrayList<PlayerListEntity?>?,
                        awayPlayList: ArrayList<PlayerListEntity?>?): BasketBallPlayerFragment {
            val args = Bundle()
            val fragment = BasketBallPlayerFragment()
            args.putString(Constants.HOME_TEAM_NAME, homeName)
            args.putString(Constants.AWAY_TEAM_NAME, awayName)
            args.putSerializable(Constants.HOME_TEAM, homePlayList)
            args.putSerializable(Constants.AWAY_TEAM, awayPlayList)
            args.putString(Constants.ROOM_ID, id)
            fragment.arguments = args
            return fragment
        }
    }


}