package com.hupu.tv.player.app.ui.fragment

import android.content.Context
import android.os.Bundle
import android.view.View
import android.widget.ImageView
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import com.softgarden.baselibrary.base.BaseActivity
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.base.RefreshFragment
import com.hupu.tv.player.app.base.RefreshVP2Fragment
import com.hupu.tv.player.app.bean.*
import com.hupu.tv.player.app.ui.adapter.MatchTeamAdapter
import com.hupu.tv.player.app.ui.adapter.MatchTeamTopAdapter
import com.hupu.tv.player.app.ui.contact.BasketBallTeamFragmentContact
import com.hupu.tv.player.app.ui.presenter.BasketBallTeamFragmentPresenter
import com.hupu.tv.player.app.utils.GlideUtils
import kotlinx.android.synthetic.main.fragment_team_new.*
import kotlinx.android.synthetic.main.layout_empty.*


/**
 * @author by Dell
 * @date on 2020/6/15
 * @describe
 */
class BasketBallTeamFragment : RefreshVP2Fragment<BasketBallTeamFragmentPresenter>(), BasketBallTeamFragmentContact.Display {
    /**
     * 因为两个View叠加在一起，没办法使用LinearLayout 的weight，所以要通过得分来计算
     * 因为最大长度为200
     * 故宽度简单计算为
     * if(team.score == 0){
     * width = 0
     * awayWidth = 200
     * }
     * if（team.score > awayTeam.score){
     *   k = team.score/awayTeam.score
     * }else{
     *   k = awayTeam.score/team.score
     * }
     * val awayWidth = if (k >1 && k<2){
     *  width = 200/2 * k
     *  awayWidth = 200/2 * （k + 0.01)
     * }else if(k > 2)
     *  awayWidth = 200/10 * k
     *  width = 200/10 * k
     */
    private lateinit var adapter: MatchTeamAdapter
    private lateinit var topAdapter: MatchTeamTopAdapter
    private var roomid = ""
    private var homeTeam: Team? = null
    private var awayTeam: Team? = null
    private var homeCompetition: CompetitionEntity? = null
    private var awayCompetition: CompetitionEntity? = null


    override val layoutId: Int
        get() = R.layout.fragment_team_new

    override val baseActivity: BaseActivity<*>?
        get() = activity as BaseActivity<*>

    override fun onRequestRoomInfo(bean: RoomInfoBean?) {

    }


    override val ctx: Context?
        get() = super.ctx

    override fun initEventAndData() {
        arguments?.let {
            roomid = it.getString(Constants.ROOM_ID, "")
            homeTeam = it.getSerializable(Constants.HOME_TEAM) as? Team
            awayTeam = it.getSerializable(Constants.AWAY_TEAM) as? Team
            homeCompetition = it.getSerializable(Constants.HOME_TEAM_COMPETITION) as? CompetitionEntity?
            awayCompetition = it.getSerializable(Constants.AWAY_TEAM_COMPETITION) as? CompetitionEntity?
        }
        if (homeCompetition == null && awayCompetition == null) {
            ll_empty.visibility = View.VISIBLE
        } else {
            ll_empty.visibility = View.GONE
            initRefreshLayout()
            initRecyclerView()
            initTeamAdapter()
            initAdapter()
        }

    }

    private fun initTeamAdapter() {
        recycler_team.layoutManager = LinearLayoutManager(requireContext())
        topAdapter = MatchTeamTopAdapter(R.layout.item_match_team_top)
        topAdapter.addHeaderView(View.inflate(requireContext(), R.layout.item_match_team_top_header, null))
        recycler_team.adapter = topAdapter
        topAdapter.setNewData(loadTopData())
    }

    private fun loadTopData(): MutableList<MatchTopItemEntity>? {
        val topEntityList = arrayListOf<MatchTopItemEntity>()
        val homeScore = homeCompetition?.scoreSettle ?: ""
        val homeSplit = homeScore.split(",")
        if (homeSplit.size == 6) {
            topEntityList.add(MatchTopItemEntity(1,
                    homeTeam?.teamName,
                    homeSplit[0],
                    homeSplit[1],
                    homeSplit[2],
                    homeSplit[3],
                    homeSplit[4],
                    homeSplit[5]))
        }
        val awayScore = awayCompetition?.scoreSettle ?: ""
        val awaySplit = awayScore.split(",")
        if (awaySplit.size == 6) {
            topEntityList.add(MatchTopItemEntity(2,
                    awayTeam?.teamName,
                    awaySplit[0],
                    awaySplit[1],
                    awaySplit[2],
                    awaySplit[3],
                    awaySplit[4],
                    awaySplit[5]))
        }
        return topEntityList
    }

    private fun initAdapter() {
        adapter = MatchTeamAdapter(R.layout.item_match_team)
        mRecyclerView?.layoutManager = LinearLayoutManager(requireActivity())
        mRecyclerView?.adapter = adapter
        val headerView = View.inflate(requireContext(), R.layout.item_match_team_header, null)
        val ivHome = headerView.findViewById<ImageView>(R.id.iv_home)
        val ivAway = headerView.findViewById<ImageView>(R.id.iv_away)
        GlideUtils.loadAvatar(this, homeTeam?.teamLogo, ivHome)
        GlideUtils.loadAvatar(this, awayTeam?.teamLogo, ivAway)
        adapter.addHeaderView(headerView)
        adapter.setNewData(loadData())
    }

    private fun loadData(): MutableList<MatchTeamBean>? {
        val list = arrayListOf<MatchTeamBean>()
        list.add(MatchTeamBean("得分", homeCompetition?.score ?: 0, awayCompetition?.score ?: 0))
        list.add(MatchTeamBean("投篮", homeCompetition?.shots ?: 0, awayCompetition?.shots ?: 0))
        list.add(MatchTeamBean("投篮命中", homeCompetition?.shootNum ?: 0, awayCompetition?.shootNum
                ?: 0))
        list.add(MatchTeamBean("三分", homeCompetition?.threeShots ?: 0, awayCompetition?.threeShots
                ?: 0))
        list.add(MatchTeamBean("三分命中", homeCompetition?.threeShotNum
                ?: 0, awayCompetition?.threeShotNum ?: 0))
        list.add(MatchTeamBean("罚球", homeCompetition?.freeThrows ?: 0, awayCompetition?.freeThrows
                ?: 0))
        list.add(MatchTeamBean("罚球命中", homeCompetition?.freeThrowNum
                ?: 0, awayCompetition?.freeThrowNum ?: 0))
        list.add(MatchTeamBean("助攻", homeCompetition?.assists ?: 0, awayCompetition?.assists ?: 0))
        list.add(MatchTeamBean("进攻篮板", homeCompetition?.attackBoard
                ?: 0, awayCompetition?.attackBoard ?: 0))
        list.add(MatchTeamBean("防守篮板", homeCompetition?.defensiveBoard
                ?: 0, awayCompetition?.defensiveBoard
                ?: 0))
        list.add(MatchTeamBean("抢断", homeCompetition?.steals ?: 0, awayCompetition?.steals ?: 0))
        list.add(MatchTeamBean("失误", homeCompetition?.error ?: 0, awayCompetition?.error ?: 0))
        list.add(MatchTeamBean("盖帽", homeCompetition?.blocks ?: 0, awayCompetition?.blocks ?: 0))
        list.add(MatchTeamBean("犯规", homeCompetition?.foul ?: 0, awayCompetition?.foul ?: 0))
        list.add(MatchTeamBean("篮板", homeCompetition?.totalBoards ?: 0, awayCompetition?.totalBoards
                ?: 0))
        return list
    }


    override fun lazyLoad() {
        presenter?.getRoomInfo(roomid)
        mRecyclerView?.postDelayed({
            finishRefresh()
        }, 3000)
    }


    companion object {
        @JvmStatic
        fun newInstance(id: String,
                        homeTeam: Team?,
                        awayTeam: Team?,
                        competition: CompetitionEntity?,
                        awayCompetition: CompetitionEntity?): BasketBallTeamFragment {
            val args = Bundle()
            val fragment = BasketBallTeamFragment()
            args.putSerializable(Constants.HOME_TEAM, homeTeam)
            args.putSerializable(Constants.AWAY_TEAM, awayTeam)
            args.putSerializable(Constants.HOME_TEAM_COMPETITION, competition)
            args.putSerializable(Constants.AWAY_TEAM_COMPETITION, awayCompetition)
            args.putString(Constants.ROOM_ID, id)
            fragment.arguments = args
            return fragment
        }
    }


}