package com.hupu.tv.player.app.ui.fragment;

import android.app.Activity;
import android.app.Dialog;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.PopupWindow;
import android.widget.RelativeLayout;

import androidx.annotation.Nullable;

import com.hupu.tv.player.app.bean.FakeMessageEntity;
import com.hupu.tv.player.app.ui.activity.LiveActivity;
import com.hupu.tv.player.app.widget.customIm.CustomEaseChatMessageListLayout;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMMessage;
import com.hyphenate.easeui.interfaces.EaseChatRoomListener;
import com.hyphenate.easeui.modules.chat.EaseChatMessageListLayout;
import com.hyphenate.easeui.modules.chat.interfaces.OnRecallMessageResultListener;
import com.hyphenate.easeui.modules.menu.EasePopupWindowHelper;
import com.hyphenate.easeui.modules.menu.MenuItemBean;
import com.hyphenate.util.EMLog;
import com.hyphenate.util.UriUtils;
import com.softgarden.baselibrary.utils.SPUtil;
import com.hupu.tv.player.app.R;
import com.hupu.tv.player.app.app.Constants;
import com.hupu.tv.player.app.bean.LiveUserBean;
import com.hupu.tv.player.app.widget.danmuku.CustomChatPrimaryMenu;

import java.util.Objects;
import java.util.Random;


public class ChatFragment extends CustomEaseChatFragment implements OnRecallMessageResultListener {
    private static final String TAG = ChatFragment.class.getSimpleName();
    private String liveUserName = "";
    protected ClipboardManager clipboard;
    private boolean isSend = false;
    private static final int REQUEST_CODE_SELECT_AT_USER = 15;
    private static final String[] calls = {"视频通话", "语音通话"};
    private OnFragmentInfoListener infoListener;
    private OnMemberJoinListener onMemberJoinListener;
    private Dialog dialog;
    private CustomChatPrimaryMenu customChatPrimaryMenu;
    private CustomChatRoomListener customChatRoomListener;

    @Override
    public void initView() {
        super.initView();
        liveUserName = getArguments().getString(Constants.LIVE_ROOM_USER_NAME);
        chatLayout.getChatMessageListLayout().setItemShowType(EaseChatMessageListLayout.ShowType.LEFT);
        chatLayout.getChatMessageListLayout().setBackground(new ColorDrawable(Color.parseColor("#F4F4F4")));
        customChatPrimaryMenu = new CustomChatPrimaryMenu(getContext());
        chatLayout.getChatInputMenu().setCustomPrimaryMenu(customChatPrimaryMenu);
        clipboard = (ClipboardManager) getActivity().getSystemService(Context.CLIPBOARD_SERVICE);
        LiveConversationFragment parentFragment = (LiveConversationFragment) getParentFragment();

        customChatPrimaryMenu.setOnSendMessageListener(message -> parentFragment.sendDanmu(message, true));
        setShowChatPrimaryMenu();
    }

    public void setOnMemberJoinListener(OnMemberJoinListener onMemberJoinListener) {
        this.onMemberJoinListener = onMemberJoinListener;
    }

    public void setShowChatPrimaryMenu() {
        Boolean login = (Boolean) SPUtil.Companion.get(Constants.USER_LOGIN, false);
        if (!login) {
            customChatPrimaryMenu.setVisibility(View.GONE);
        } else {
            customChatPrimaryMenu.setVisibility(View.VISIBLE);
        }
    }


    @Override
    public boolean addMsgAttrsBeforeSend(EMMessage message) {
        if ((Boolean) SPUtil.Companion.get(Constants.USER_LOGIN, false)) {
            LiveUserBean liveUserBean = SPUtil.Companion.getSerializableObject(Constants.LIVE_USER_BEAN);
            if (liveUserBean != null) {
                message.setAttribute(Constants.USER_NICK, liveUserBean.getUserName());
                message.setAttribute(Constants.USER_LEVEL, liveUserBean.getLevel());
            }
        }
        return super.addMsgAttrsBeforeSend(message);
    }

    @Override
    public void initListener() {
        super.initListener();
        chatLayout.setOnRecallMessageResultListener(this);
    }

    @Override
    public void initData() {
        super.initData();
//        resetChatExtendMenu();
        chatLayout.getChatInputMenu().getPrimaryMenu().getEditText().setText(getUnSendMsg());
        customChatRoomListener = new CustomChatRoomListener();
        EMClient.getInstance().chatroomManager().addChatRoomChangeListener(customChatRoomListener);
        CustomEaseChatMessageListLayout chatMessageListLayout = chatLayout.getChatMessageListLayout();
        chatMessageListLayout.setOnJoinRoomListener(new CustomEaseChatMessageListLayout.OnJoinRoomListener() {
            @Override
            public void onJoinRoomSuccess() {
                importHistory();
                sendJoinRoomData();


            }

            @Override
            public void onJoinRoomFailure() {

            }
        });
    }

    private void importHistory() {
        LiveConversationFragment parentFragment = (LiveConversationFragment) getParentFragment();
        LiveActivity activity = (LiveActivity) parentFragment.getActivity();
        if (activity != null) {
            chatLayout.getChatMessageListLayout().setHistoryListData(activity.getHistoryList());
        }

//        if (activity != null) {
//            ArrayList<HistoryMessageEntity> historyList = activity.getHistoryList();
//            ArrayList<EMMessage> emMessages = new ArrayList<>();
//            for (HistoryMessageEntity entity : historyList) {
//                EMMessage msg = EMMessage.createReceiveMessage(EMMessage.Type.TXT);
//                EMTextMessageBody body = new EMTextMessageBody(entity.getMsgContent());
//                msg.addBody(body);
//                msg.setTo(conversationId);
//                msg.setFrom(entity.getSendUser());
//                msg.setMsgTime(System.currentTimeMillis());
//                msg.setAttribute(Constants.USER_NICK, entity.getSendUser());
//                msg.setIsNeedGroupAck(false);
//                msg.setChatType(EMMessage.ChatType.ChatRoom);
//                emMessages.add(msg);
//            }
//            EMClient.getInstance().chatManager().importMessages(emMessages);
//        }
    }

    @Override
    public void onResume() {
        super.onResume();
    }

    public void sendJoinRoomData() {
        if (!isSend) {
            if ((Boolean) (SPUtil.Companion.get(Constants.USER_LOGIN, false))) {
                chatLayout.sendTextMessage("进入直播间");
            }
            sendFakeMessage();
            isSend = true;
        }

    }

    private void sendFakeMessage() {
        FakeMessageEntity fakeMessage = SPUtil.Companion.getSerializableObject(Constants.FAKE_MESSAGE);
        if (fakeMessage != null) {
            int anInt = new Random().nextInt(10);
            EMMessage message = EMMessage.createTxtSendMessage(Objects.requireNonNull(fakeMessage.getMsgContent()), conversationId);
            message.setAttribute(Constants.USER_NICK, fakeMessage.getSendUser());
            message.setAttribute(Constants.USER_LEVEL, (anInt + 1));
            message.setIsNeedGroupAck(false);
            message.setChatType(EMMessage.ChatType.ChatRoom);
            EMClient.getInstance().chatManager().sendMessage(message);
        }
    }

    @Override
    public void onUserAvatarLongClick(String username) {

    }

    @Override
    public boolean onBubbleLongClick(View v, EMMessage message) {
        return false;
    }


    @Override
    public boolean onBubbleClick(EMMessage message) {
        return false;
    }

    @Override
    public void onChatError(int code, String errorMsg) {
        if (infoListener != null) {
            infoListener.onChatError(code, errorMsg);
        }
    }

    @Override
    public void onOtherTyping(String action) {
        if (infoListener != null) {
            infoListener.onOtherTyping(action);
        }
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode == Activity.RESULT_OK) {
            switch (requestCode) {
                case REQUEST_CODE_SELECT_AT_USER:
                    if (data != null) {
                        String username = data.getStringExtra("username");
                        chatLayout.inputAtUsername(username, false);
                    }
                    break;
                case REQUEST_CODE_SELECT_VIDEO: //send the video
                    if (data != null) {
                        int duration = data.getIntExtra("dur", 0);
                        String videoPath = data.getStringExtra("path");
                        String uriString = data.getStringExtra("uri");
                        EMLog.d(TAG, "path = " + videoPath + " uriString = " + uriString);
                        if (!TextUtils.isEmpty(videoPath)) {
                            chatLayout.sendVideoMessage(Uri.parse(videoPath), duration);
                        } else {
                            Uri videoUri = UriUtils.getLocalUriFromString(uriString);
                            chatLayout.sendVideoMessage(videoUri, duration);
                        }
                    }
                    break;
            }
        }
    }

    @Override
    public void onStop() {
        super.onStop();
        //保存未发送的文本消息内容
        if (mContext != null && mContext.isFinishing()) {
            if (chatLayout.getChatInputMenu() != null) {
                saveUnSendMsg(chatLayout.getInputContent());
//                LiveDataBus.get().with(DemoConstant.MESSAGE_NOT_SEND).postValue(true);
            }
        }
    }

    //================================== for video and voice start ====================================

    /**
     * 保存未发送的文本消息内容
     *
     * @param content
     */
    private void saveUnSendMsg(String content) {
//        DemoHelper.getInstance().getModel().saveUnSendMsg(conversationId, content);
    }

    private String getUnSendMsg() {
//        return DemoHelper.getInstance().getModel().getUnSendMsg(conversationId);
        return "";
    }

    @Override
    public void onPreMenu(EasePopupWindowHelper helper, EMMessage message) {
        //默认两分钟后，即不可撤回
        if (System.currentTimeMillis() - message.getMsgTime() > 2 * 60 * 1000) {
            helper.findItemVisible(R.id.action_chat_recall, false);
        }
        EMMessage.Type type = message.getType();
//        helper.findItemVisible(R.id.action_chat_forward, false);
//        switch (type) {
//            case TXT:
//                if(!message.getBooleanAttribute(DemoConstant.MESSAGE_ATTR_IS_VIDEO_CALL, false)
//                        && !message.getBooleanAttribute(DemoConstant.MESSAGE_ATTR_IS_VOICE_CALL, false)) {
//                    helper.findItemVisible(R.id.action_chat_forward, true);
//                }
//                break;
//            case IMAGE:
//                helper.findItemVisible(R.id.action_chat_forward, true);
//                break;
//        }
//
//        if(chatType == DemoConstant.CHATTYPE_CHATROOM) {
//            helper.findItemVisible(R.id.action_chat_forward, true);
//        }
    }

    @Override
    public boolean onMenuItemClick(MenuItemBean item, EMMessage message) {
        switch (item.getItemId()) {
//            case R.id.action_chat_forward :
//                ForwardMessageActivity.actionStart(mContext, message.getMsgId());
//                return true;
            case R.id.action_chat_delete:
                showDeleteDialog(message);
                return true;
            case R.id.action_chat_recall:
                showProgressBar();
                chatLayout.recallMessage(message);
                return true;
        }
        return false;
    }

    @Override
    public void onDismiss(PopupWindow menu) {

    }

    private void showProgressBar() {
//        View view = View.inflate(mContext, R.layout.demo_layout_progress_recall, null);
//        dialog = new Dialog(mContext,R.style.dialog_recall);
//        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);
//        dialog.setContentView(view, layoutParams);
//        dialog.setCancelable(false);
//        dialog.setCanceledOnTouchOutside(true);
//        dialog.show();
    }

    private void showDeleteDialog(EMMessage message) {
//        new SimpleDialogFragment.Builder((BaseActivity) mContext)
//                .setTitle(getString(R.string.em_chat_delete_title))
//                .setConfirmColor(R.color.red)
//                .setOnConfirmClickListener(getString(R.string.delete), new DemoDialogFragment.OnConfirmClickListener() {
//                    @Override
//                    public void onConfirmClick(View view) {
//                        chatLayout.deleteMessage(message);
//                    }
//                })
//                .showCancelButton(true)
//                .show();
    }

    public void setOnFragmentInfoListener(OnFragmentInfoListener listener) {
        this.infoListener = listener;
    }

    @Override
    public void recallSuccess(EMMessage message) {
        if (dialog != null && dialog.isShowing()) {
            dialog.dismiss();
        }
    }

    @Override
    public void recallFail(int code, String errorMsg) {
        if (dialog != null && dialog.isShowing()) {
            dialog.dismiss();
        }
    }

    public interface OnFragmentInfoListener {
        void onChatError(int code, String errorMsg);

        void onOtherTyping(String action);
    }

    public interface OnMemberJoinListener {
        void onMemberJoin(String id);
    }

    private class CustomChatRoomListener extends EaseChatRoomListener {

        @Override
        public void onChatRoomDestroyed(String roomId, String roomName) {

        }

        @Override
        public void onRemovedFromChatRoom(int reason, String roomId, String roomName, String participant) {
            if (!TextUtils.equals(roomId, conversationId)) {
                return;
            }

        }

        @Override
        public void onMemberJoined(String roomId, String participant) {
            //todo 成员加入
            Log.e("chatListener", "join" + participant);
            if (onMemberJoinListener != null) {
                onMemberJoinListener.onMemberJoin(participant);
            }

        }

        @Override
        public void onMemberExited(String roomId, String roomName, String participant) {
            int i = 0;
        }
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        EMClient.getInstance().chatroomManager().removeChatRoomListener(customChatRoomListener);
        CustomEaseChatMessageListLayout chatMessageListLayout = chatLayout.getChatMessageListLayout();
        if (chatMessageListLayout != null) {
            chatMessageListLayout.setOnChatErrorListener(null);
            chatMessageListLayout.setOnMessageTouchListener(null);
            chatMessageListLayout.setMessageListItemClickListener(null);
            RelativeLayout parent = (RelativeLayout) chatMessageListLayout.getParent();
            parent.removeView(chatMessageListLayout);
            chatLayout.removeView(chatMessageListLayout);

            chatMessageListLayout = null;

        }
        if (chatLayout != null) {
            chatLayout = null;
        }
    }


}