package com.hupu.tv.player.app.ui.fragment

import android.content.Intent
import android.os.Bundle
import android.view.View
import androidx.appcompat.app.AppCompatActivity
import androidx.recyclerview.widget.GridLayoutManager
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView

import com.mirkowu.basetoolbar.BaseToolbar
import com.softgarden.baselibrary.utils.RecyclerViewUtil
import com.softgarden.baselibrary.utils.SPUtil
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.base.RefreshVP2Fragment
import com.hupu.tv.player.app.base.ToolbarFragment
import com.hupu.tv.player.app.bean.*
import com.hupu.tv.player.app.event.FollowAnchorEvent
import com.hupu.tv.player.app.event.RefreshUserEvent
import com.hupu.tv.player.app.ui.activity.LiveActivity
import com.hupu.tv.player.app.ui.activity.MaterialDetailActivity
import com.hupu.tv.player.app.ui.adapter.*
import com.hupu.tv.player.app.ui.contact.FollowAnchorContract
import com.hupu.tv.player.app.ui.contact.HaveMaterialContract
import com.hupu.tv.player.app.ui.presenter.FollowAnchorPresenter
import com.hupu.tv.player.app.ui.presenter.HaveMaterialPresenter
import com.hupu.tv.player.app.ui.presenter.MainHaveMaterialPresenter
import com.hupu.tv.player.app.utils.DialogUtils
import com.hupu.tv.player.app.utils.EmptyConfig
import com.kongzue.dialog.v3.WaitDialog
import com.softgarden.baselibrary.utils.ToastUtil
import kotlinx.android.synthetic.main.fragment_follow_content.*
import org.greenrobot.eventbus.EventBus
import org.greenrobot.eventbus.Subscribe
import org.greenrobot.eventbus.ThreadMode


/**
 * @author by Dell
 * @date on 2020/6/14
 * @describe
 */
class ChildSpecilistMaterialFragment : RefreshVP2Fragment<HaveMaterialPresenter>(),
    HaveMaterialContract.Display {
    private var sportId = ""
    private var specialistId = ""
    private lateinit var mAdapter: ChildMaterialListAdapter
    override val layoutId: Int
        get() = R.layout.fragment_have_material




    override fun initEventAndData() {
        sportId = arguments?.getString(CategoryBean.ID).orEmpty()
        specialistId = arguments?.getString(Constants.SPECIALIST_ID).orEmpty()
        initRecyclerView()
        initRefreshLayout()
        initAdapter()


        initStatusLayout(mRefreshLayout as View)
        mStatusLayoutManager.showLoadingLayout()

    }

    private fun initAdapter() {
        mRecyclerView?.apply {
            mAdapter = ChildMaterialListAdapter(sportId).apply {
                setOnItemClickListener { adapter, view, position ->
                    startActivity(Intent(requireContext(),MaterialDetailActivity::class.java).apply {
                        putExtra(Constants.RED_DETAIL_ID,(adapter.getItem(position) as SpecialBallItemBean).id)
                        putExtra(Constants.SPORT_TYPE,sportId)
                    })
                }
            }
            adapter = mAdapter
            RecyclerViewUtil.addItemDecoration(requireActivity(), this, R.color.transparent, 2)
        }
    }

    override fun lazyLoad() {
        presenter?.getSpecialist(specialistId, mPage, PAGE_COUNT, sportId.toInt())
    }


    companion object {
        fun newInstance(id: String, title: String,specialistId:String): ChildSpecilistMaterialFragment {
            val args = Bundle()
            val fragment = ChildSpecilistMaterialFragment()
            args.putString(CategoryBean.ID, id)
            args.putString(CategoryBean.TITLE, title)
            args.putString(Constants.SPECIALIST_ID, specialistId)
            fragment.arguments = args
            return fragment
        }
    }

    override fun onDestroy() {
        super.onDestroy()
        EventBus.getDefault().unregister(this)
    }

    override fun onSpecialist(data: MutableList<SpecialBallItemBean>?) {
        mStatusLayoutManager.showSuccessLayout()
        setLoadMore(mAdapter, data)
    }

}