package com.hupu.tv.player.app.ui.fragment

import android.content.Context
import android.os.Build
import android.os.Bundle


import android.view.KeyEvent
import android.view.View
import android.view.ViewGroup
import android.webkit.*
import android.widget.FrameLayout
import androidx.recyclerview.widget.LinearLayoutManager


import com.softgarden.baselibrary.base.BaseActivity

import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.utils.RecyclerViewUtil
import com.softgarden.baselibrary.utils.SPUtil
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.base.RefreshFragment
import com.hupu.tv.player.app.bean.IconBean
import com.hupu.tv.player.app.ui.activity.MainActivity
import com.hupu.tv.player.app.ui.activity.MineBuyVipActivity
import com.hupu.tv.player.app.ui.adapter.TitTokIconAdapter
import kotlinx.android.synthetic.main.fragment_web_view.*


/**
 * @author by Dell
 * @date on 2020/6/15
 * @describe
 */
class H5Fragment : RefreshFragment<IBasePresenter>() {
    private var mWebView: WebView? = null
    private var isOnPause = false
    override val layoutId: Int
        get() = R.layout.fragment_web_view

    override val baseActivity: BaseActivity<*>?
        get() = activity as BaseActivity<*>

    override val ctx: Context?
        get() = super.ctx


    override fun initEventAndData() {
        initWebView()
        initListener()
        initPromoteRecyclerView()
        loadUrl(SPUtil[Constants.INNER_YB_H5, Constants.DEFUALT_YB_H5] as String)
    }

    private fun initListener() {
        iv_main.setOnClickListener {
            val mainActivity = activity as MainActivity
            mainActivity.getTabLayout().currentTab = 0
        }
        iv_recharge.setOnClickListener {
            startActivity(MineBuyVipActivity::class.java)
        }
    }

    private fun initPromoteRecyclerView() {
        val tikTokList = SPUtil.getSerializableObject<ArrayList<IconBean>>(Constants.H5_AD)
                ?: arrayListOf()
        recycler_web.layoutManager = LinearLayoutManager(baseActivity)
        val tikAdapter = TitTokIconAdapter(R.layout.item_tit_web, baseActivity, tikTokList)
        recycler_web.adapter = tikAdapter
        if (recycler_web?.itemDecorationCount == 0) {
            baseActivity?.let {
                RecyclerViewUtil.addItemDecoration(it, recycler_web!!, R.color.transparent, 10)
            }

        }
    }

    override fun onBackPress(): Boolean {
        if (mWebView?.canGoBack() == true) {
            mWebView?.goBack()
            return true
        }
        return super.onBackPress()
    }


    /***
     * 方式1：加载url
     *
     * @param url
     */
    private fun loadUrl(url: String) {
        val webSettings = mWebView?.settings
        //设置自适应屏幕，两者合用
        webSettings?.useWideViewPort = true //将图片调整到适合webview的大小
        webSettings?.loadWithOverviewMode = true // 缩放至屏幕的大小
        mWebView?.loadUrl(url)
    }

    /**
     * 方式2：加载html文本
     *
     * @param content
     */
    private fun loadText(content: String) {
        val webSettings = mWebView?.settings
        //设置自适应屏幕，两者合用
        webSettings?.useWideViewPort = false //将图片调整到适合webview的大小
        webSettings?.loadWithOverviewMode = false // 缩放至屏幕的大小
        /*** 完美自适应屏幕  */
        val sb = StringBuilder()
        sb.append(content)
                .append("<html>")
                .append("<head>")
                .append("<meta charset=\\\"utf-8\\\">")
                .append("<meta id=\\\"viewport\\\" name=\\\"viewport\\\" content=\\\"width=device-width*0.9,initial-scale=1.0,maximum-scale=1.0,user-scalable=false\\\" />")
                .append("<meta name=\\\"apple-mobile-web-app-capable\\\" content=\\\"yes\\\" />")
                .append("<meta name=\\\"apple-mobile-web-app-status-bar-style\\\" content=\\\"black\\\" />")
                .append("<meta name=\\\"black\\\" name=\\\"apple-mobile-web-app-status-bar-style\\\" />")
                .append("<style>img{width:100%;}</style>")
                .append("<style>iframe{width:100%;}</style>")
                .append("<style>table{width:100%;}</style>")
                .append("<style>body{font-size:18px;}</style>")
                .append("<title>mWebView</title>")
        mWebView?.loadDataWithBaseURL(null, sb.toString(), "text/html", "utf-8", null)
    }


    override fun lazyLoad() {
    }

    private fun initWebView() {
        mWebView = WebView(ctx)
        mFrameLayout.addView(mWebView, 0, FrameLayout.LayoutParams(
                ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT))

        // mWebView.setBackgroundColor(ContextCompat.getColor(this, R.color.colorTheme)); // 设置背景色
        val webSettings = mWebView?.settings

        //如果访问的页面中要与Javascript交互，则webview必须设置支持Javascript
        webSettings?.let {
            it.javaScriptEnabled = true

        }

        //支持插件
        webSettings?.pluginState = WebSettings.PluginState.ON


//        //设置自适应屏幕，两者合用  这样会使加载文本时 文字变小
//        webSettings?.setUseWideViewPort(true); //将图片调整到适合webview的大小
//        webSettings?.setLoadWithOverviewMode(true); // 缩放至屏幕的大小
        webSettings?.setRenderPriority(WebSettings.RenderPriority.HIGH) //提高渲染的优先级

        //缩放操作
        webSettings?.setSupportZoom(true) //支持缩放，默认为true。是下面那个的前提。
        webSettings?.builtInZoomControls = true //设置内置的缩放控件。若为false，则该WebView不可缩放
        webSettings?.displayZoomControls = false //隐藏原生的缩放控件

        //开启DomStorage缓存
        webSettings?.domStorageEnabled = true
        //        //启用数据库
        webSettings?.databaseEnabled = true
        //        //设置定位的数据库路径
//        String dir = this.getApplicationContext().getDir("database", Context.MODE_PRIVATE).getPath();
//        webSettings?.setGeolocationDatabasePath(dir);

        //其他细节操作
        webSettings?.cacheMode = WebSettings.LOAD_NO_CACHE //不使用缓存
        webSettings?.allowFileAccess = true //设置可以访问文件
        webSettings?.javaScriptCanOpenWindowsAutomatically = true //支持通过JS打开新窗口
        webSettings?.loadsImagesAutomatically = true //支持自动加载图片
        webSettings?.defaultTextEncodingName = "utf-8" //设置编码格式
        //支持内容重新布局
        webSettings?.layoutAlgorithm = WebSettings.LayoutAlgorithm.SINGLE_COLUMN
        //这个是加载的地址是https的，一些资源文件使用的是http方法的，
        // 从安卓4.4之后对webview安全机制有了加强，webview里面加载https url的时候，
        // 如果里面需要加载http的资源或者重定向的时候，webview会block页面加载。需要设置MixedContentMode
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            webSettings?.mixedContentMode = WebSettings.MIXED_CONTENT_ALWAYS_ALLOW
        }
        mWebView?.webChromeClient = object : WebChromeClient() {
            override fun onProgressChanged(view: WebView, newProgress: Int) {
                if (newProgress >= 99) {
                    mProgressBar?.visibility = View.GONE
                } else {
                    mProgressBar?.visibility = View.VISIBLE
                    mProgressBar?.progress = newProgress
                }
            }
        }
        mWebView?.webViewClient = object : WebViewClient() {
            override fun onPageFinished(view: WebView, url: String) {
                super.onPageFinished(view, url)
                mProgressBar?.visibility = View.GONE
            }
        }
    }

    override fun onKeyDown(event: KeyEvent?): Boolean {
        if (mWebView?.canGoBack() == true) {
            mWebView?.goBack()
            return true
        }
        return super.onKeyDown(event)
    }


    /**
     * 当Activity执行onResume()时让WebView执行resume
     */
    override fun onResume() {
        super.onResume()
        try {
            if (isOnPause) {
                if (mWebView != null) {
                    mWebView?.javaClass?.getMethod("onResume")?.invoke(mWebView, null as Array<Any?>?)
                }
                isOnPause = false
            }
        } catch (e: Exception) {
            e.printStackTrace()
        }
    }


    /**
     * 当Activity执行onPause()时让WebView执行pause
     */
    override fun onPause() {
        super.onPause()
        try {
            if (mWebView != null) {
                mWebView?.javaClass?.getMethod("onPause")?.invoke(mWebView, null as Array<Any?>?)
                isOnPause = true
            }
        } catch (e: java.lang.Exception) {
            e.printStackTrace()
        }
    }


    public override fun onDestroy() {
        mWebView?.let {
            mFrameLayout?.removeView(it)
            it.stopLoading()
            it.destroyDrawingCache()
            it.removeAllViews()
            //mWebView.loadDataWithBaseURL(null, "", "text/html", "utf-8", null);
            it.clearHistory()
            it.destroy()
        }
        mWebView = null
        super.onDestroy()
    }

    companion object {
        @JvmStatic
        fun newInstance(): H5Fragment {
            val args = Bundle()
            val fragment = H5Fragment()
            fragment.arguments = args
            return fragment
        }
    }


}