package com.hupu.tv.player.app.ui.fragment

import android.content.Context
import android.os.Bundle
import com.softgarden.baselibrary.base.BaseActivity
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.base.RefreshFragment
import com.hupu.tv.player.app.base.RefreshVP2Fragment
import com.hupu.tv.player.app.bean.RoomInfoBean
import com.hupu.tv.player.app.bean.RoomInfoEntity
import com.hupu.tv.player.app.ui.contact.LiveAnchorFragmentContact
import com.hupu.tv.player.app.ui.presenter.LiveAnchorFragmentPresenter
import com.hupu.tv.player.app.utils.GlideUtils
import kotlinx.android.synthetic.main.fragment_anchor.*


/**
 * @author by Dell
 * @date on 2020/6/15
 * @describe
 */
class LiveAnchorFragment : RefreshVP2Fragment<LiveAnchorFragmentPresenter>(), LiveAnchorFragmentContact.Display {
    private var roomid = ""
    override val layoutId: Int
        get() = R.layout.fragment_anchor

    override val baseActivity: BaseActivity<*>?
        get() = activity as BaseActivity<*>

    override fun onRequestRoomInfo(bean: RoomInfoEntity?) {
        bean?.let {
            tv_short_name.text = bean.roomName
            tv_room.text = getString(R.string.string_room_num, bean.roomNum)
            tv_name.text = bean.anchorName
//            tv_describe.text = bean.anchorDesc
            tv_anchor_notice.text = bean.roomAnnouncement
            GlideUtils.loadAvatar(this, bean.anchorAvatar, iv_avatar)
        }
    }


    override val ctx: Context?
        get() = super.ctx

    override fun initEventAndData() {
        initRefreshLayout()
        arguments?.let {
            roomid = it.getString(Constants.ROOM_ID, "")
        }

    }


    override fun lazyLoad() {
        presenter?.getRoomInfo(roomid)
    }


    companion object {
        @JvmStatic
        fun newInstance(id: String): LiveAnchorFragment {
            val args = Bundle()
            val fragment = LiveAnchorFragment()
            args.putString(Constants.ROOM_ID, id)
            fragment.arguments = args
            return fragment
        }
    }


}