package com.hupu.tv.player.app.ui.fragment

import android.content.Intent
import android.os.Bundle
import android.util.Log
import android.view.View
import androidx.appcompat.app.AppCompatActivity
import com.hyphenate.easeui.constants.EaseConstant
import com.softgarden.baselibrary.utils.SPUtil
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.base.RefreshFragment
import com.hupu.tv.player.app.base.RefreshVP2Fragment
import com.hupu.tv.player.app.bean.GiftBean
import com.hupu.tv.player.app.bean.LiveUserBean
import com.hupu.tv.player.app.event.RefreshUserEvent
import com.hupu.tv.player.app.ui.activity.LiveActivity
import com.hupu.tv.player.app.ui.activity.ReportActivity
import com.hupu.tv.player.app.ui.activity.UserFeedBackActivity
import com.hupu.tv.player.app.ui.activity.UserToFeedBackActivity
import com.hupu.tv.player.app.ui.contact.LiveConversationFragmentContact
import com.hupu.tv.player.app.ui.presenter.LiveConversationFragmentPresenter
import com.hupu.tv.player.app.utils.DialogUtils
import kotlinx.android.synthetic.main.fragment_live_conversation.*
import org.greenrobot.eventbus.EventBus
import org.greenrobot.eventbus.Subscribe
import org.greenrobot.eventbus.ThreadMode


/**
 * @author by Dell
 * @date on 2020/6/15
 * @describe
 */
class LiveConversationFragment : RefreshVP2Fragment<LiveConversationFragmentPresenter>(),
    LiveConversationFragmentContact.IDisplay {
    var chatFragment: ChatFragment? = null
    var liveUserName = ""

    companion object {
        @JvmStatic
        fun newInstance(
            conversationId: String,
            notice: String,
            notice2: String,
            userName: String
        ): LiveConversationFragment {
            val args = Bundle()
            args.putString(EaseConstant.EXTRA_CONVERSATION_ID, conversationId)
            args.putInt(EaseConstant.EXTRA_CHAT_TYPE, EaseConstant.CHATTYPE_CHATROOM)
            args.putBoolean(EaseConstant.EXTRA_IS_ROAM, true)
            args.putString(Constants.LIVE_NOTICE, notice)
            args.putString(Constants.LIVE_NOTICE2, notice2)
            args.putString(Constants.LIVE_ROOM_USER_NAME, userName)
            val fragment = LiveConversationFragment()
            fragment.arguments = args
            return fragment
        }
    }

    override fun initEventAndData() {
        liveUserName = arguments?.getString(Constants.LIVE_ROOM_USER_NAME, "游客50234") ?: "游客50234"
        EventBus.getDefault().register(this)
        initChatFragment()
        tv_notice.text = getString(R.string.string_live_notice, arguments?.getString(Constants.LIVE_NOTICE))
        if (!(SPUtil[Constants.SHOW_LIVE_CONFIG, false] as Boolean)){
            ll_notice2.visibility = View.GONE
        }else{
            if (arguments?.getString(Constants.LIVE_NOTICE2).isNullOrEmpty()) {
                ll_notice2.visibility = View.GONE
            } else {
                ll_notice2.visibility = View.VISIBLE
                tv_notice2.text = "系统公告:${arguments?.getString(Constants.LIVE_NOTICE2).orEmpty()}"
            }
        }

        needLogin()
        tv_report.setOnClickListener {
            startActivity(Intent(requireContext(), ReportActivity::class.java))
        }
    }

    private fun needLogin() {
        ll_need_login.visibility = View.GONE
        if (SPUtil[Constants.USER_LOGIN, false] == false) {
            ll_need_login.visibility = View.VISIBLE
            ll_need_login.setOnClickListener {
                DialogUtils.showLogin(activity as AppCompatActivity)
            }
        }
        chatFragment?.setOnMemberJoinListener {
            if (it.startsWith("live_")) {
                Log.e("joinMember", "id==$it")
                val userid = it.subSequence(5, it.length).toString()
                Log.e("joinMember", "id==$userid")
                val arrayList = ArrayList<String>()
                arrayList.add(userid)
                presenter?.getMemberById(arrayList)
            }
        }
    }

    @Subscribe(threadMode = ThreadMode.MAIN, sticky = true, priority = 1)
    fun onEventRefresh(event: RefreshUserEvent) {
        needLogin()
        chatFragment?.setShowChatPrimaryMenu()
    }

    fun sendDanmu(text: String, isMine: Boolean) {
        val liveActivity = activity as LiveActivity
        liveActivity.sendDanmu(text, isMine)
    }


    private fun initChatFragment() {
        val bundle = Bundle()
        bundle.putString(EaseConstant.EXTRA_CONVERSATION_ID, arguments?.getString(EaseConstant.EXTRA_CONVERSATION_ID))
        bundle.putInt(EaseConstant.EXTRA_CHAT_TYPE, EaseConstant.CHATTYPE_CHATROOM)
        bundle.putBoolean(EaseConstant.EXTRA_IS_ROAM, true)
        bundle.putString(Constants.LIVE_ROOM_USER_NAME, liveUserName)
        chatFragment = ChatFragment()
        chatFragment?.arguments = bundle
        childFragmentManager.beginTransaction().replace(R.id.fl_fragment, chatFragment!!, "chat").commit()


    }

    override fun lazyLoad() {
        presenter?.getGiftList()
    }

    override val layoutId: Int
        get() = R.layout.fragment_live_conversation

    override fun onRequestList(list: ArrayList<GiftBean>?) {
        SPUtil.putSerializableObject(Constants.GIFT_BEAN, list)
    }

    override fun onMemberJoinRoom(list: ArrayList<LiveUserBean>?) {

    }

    override fun onDestroy() {
        super.onDestroy()
        EventBus.getDefault().unregister(this)
    }

}