package com.hupu.tv.player.app.ui.fragment

import android.content.Context
import android.os.Bundle
import androidx.recyclerview.widget.LinearLayoutManager

import com.softgarden.baselibrary.base.BaseActivity
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.base.RefreshFragment
import com.hupu.tv.player.app.base.RefreshVP2Fragment
import com.hupu.tv.player.app.bean.LiveRankBean
import com.hupu.tv.player.app.ui.adapter.LiveRankAdapter
import com.hupu.tv.player.app.ui.contact.LiveRankFragmentContact
import com.hupu.tv.player.app.ui.presenter.LiveRankFragmentPresenter


/**
 * @author by Dell
 * @date on 2020/6/15
 * @describe
 */
class LiveRankFragment : RefreshVP2Fragment<LiveRankFragmentPresenter>(), LiveRankFragmentContact.IDisplay {
    private var roomid = ""
    private var adapter: LiveRankAdapter? = null
    override val layoutId: Int
        get() = R.layout.fragment_live_rank

    override val baseActivity: BaseActivity<*>?
        get() = activity as BaseActivity<*>


    override val ctx: Context?
        get() = super.ctx

    override fun initEventAndData() {
        initRefreshLayout()
        initRecyclerView()
        initAdapter()
        arguments?.let {
            roomid = it.getString(Constants.ROOM_ID, "")
        }
    }

    private fun initAdapter() {
        mRecyclerView?.layoutManager = LinearLayoutManager(ctx)
        adapter = LiveRankAdapter(R.layout.item_live_rank,this)
        mRecyclerView?.adapter = adapter
    }


    override fun lazyLoad() {
        presenter?.getRank(roomid)
    }

    override fun onRequestRankList(list: List<LiveRankBean>?) {
        adapter?.let {
            setLoadData(it, list)
        }
    }


    companion object {
        @JvmStatic
        fun newInstance(id: String): LiveRankFragment {
            val args = Bundle()
            args.putString(Constants.ROOM_ID, id)
            val fragment = LiveRankFragment()
            fragment.arguments = args
            return fragment
        }
    }


}