package com.hupu.tv.player.app.ui.fragment

import android.content.Intent
import android.os.Bundle
import android.view.View
import androidx.appcompat.app.AppCompatActivity
import androidx.recyclerview.widget.GridLayoutManager
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView


import com.mirkowu.basetoolbar.BaseToolbar
import com.softgarden.baselibrary.utils.L
import com.softgarden.baselibrary.utils.RecyclerViewUtil

import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.base.RefreshFragment
import com.hupu.tv.player.app.base.RefreshVP2Fragment
import com.hupu.tv.player.app.base.ToolbarFragment
import com.hupu.tv.player.app.bean.*
import com.hupu.tv.player.app.bean.MatchContentBean.MatchListsBean.MatchInfosBean
import com.hupu.tv.player.app.event.FollowMatchEvent
import com.hupu.tv.player.app.event.SubscribeEvent
import com.hupu.tv.player.app.event.VisibleEvent
import com.hupu.tv.player.app.ui.activity.LiveActivity
import com.hupu.tv.player.app.ui.activity.MatchDetailActivity
import com.hupu.tv.player.app.ui.activity.NewMatchDetailActivity
import com.hupu.tv.player.app.ui.adapter.HomeBannerAdapter
import com.hupu.tv.player.app.ui.adapter.LiveItemAdapter
import com.hupu.tv.player.app.ui.adapter.LiveTopAdapter
import com.hupu.tv.player.app.ui.contact.MainContentAllContract
import com.hupu.tv.player.app.ui.presenter.MainContentAllPresenter
import com.hupu.tv.player.app.utils.CommonUtils
import com.hupu.tv.player.app.utils.DialogUtils
import com.hupu.tv.player.app.widget.ImageCarousel
import com.softgarden.baselibrary.utils.SPUtil
import com.softgarden.baselibrary.utils.ToastUtil
import com.zhpan.bannerview.BannerViewPager
import com.zhpan.bannerview.constants.PageStyle
import com.zhpan.indicator.enums.IndicatorSlideMode
import kotlinx.android.synthetic.main.fragment_match_all.*
import me.jessyan.autosize.utils.LogUtils
import org.greenrobot.eventbus.EventBus
import org.greenrobot.eventbus.Subscribe
import org.greenrobot.eventbus.ThreadMode

/**
 * @author by Dell
 * @date on 2020/6/14
 * @describe
 */
class MainContentAllFragment : RefreshFragment<MainContentAllPresenter>(),
    MainContentAllContract.Display {
    private var sportId: String = ""
    private var liveItemAdapter: LiveItemAdapter? = null
    private var liveTopAdapter: LiveTopAdapter? = null
    override val layoutId: Int
        get() = R.layout.fragment_match_all



    override fun initEventAndData() {
        EventBus.getDefault().register(this)
        initRefreshLayout()
        initRecyclerView()
        initView()
        initStatusLayout(mRecyclerView!!)
        mStatusLayoutManager.showLoadingLayout()
    }

    private fun initView() {
        initBanner()
        initAdapter()
        arguments?.getString(CategoryBean.ID)?.let {
            sportId = it
        }
    }

    private fun initAdapter() {
        liveItemAdapter = LiveItemAdapter()
        mRecyclerView?.layoutManager = GridLayoutManager(activity, 2)
        activity?.let {
            RecyclerViewUtil.addGridItemDecoration(
                it,
                mRecyclerView!!,
                R.color.transparent,
                2 * Constants.item_divider_4
            )
        }
        mRecyclerView?.adapter = liveItemAdapter
        liveItemAdapter?.setOnItemClickListener { adapter, view, position ->
            startActivity(Intent(activity, LiveActivity::class.java).apply {
                val item: LiveBean.DataListBean =
                    adapter.getItem(position) as LiveBean.DataListBean
                putExtra(Constants.ROOM_ID, item.roomId)
                putExtra(Constants.ROOM_COVER, item.matchCutImg)
            })


        }

        liveTopAdapter = LiveTopAdapter( this)
        mRecyclerView_top.layoutManager = RecyclerViewUtil.nestedScrollNoFluent(
            mRecyclerView_top,
            LinearLayoutManager(activity, RecyclerView.HORIZONTAL, false)
        )
        mRecyclerView_top.adapter = liveTopAdapter
        RecyclerViewUtil.addItemDecoration(
            requireActivity(),
            mRecyclerView_top,
            R.color.transparent,
            Constants.item_divider,
            RecyclerView.HORIZONTAL
        )
        liveTopAdapter?.setOnItemClickListener { adapter, view, position ->

            val adapterItem = adapter.getItem(position) as MatchInfosBean?
            //            val intent = Intent(activity, MatchDetailActivity::class.java)
            val intent = Intent(activity, NewMatchDetailActivity::class.java)
            intent.putExtra(Constants.MATCH_BEAN_ID, adapterItem?.id)
            intent.putExtra(Constants.SPORT_TYPE, adapterItem?.sportsType)
            startActivity(intent)


        }
    }

    private fun initBanner() {
        val list = SPUtil.getSerializableObject<ArrayList<BannerBean>>(Constants.BANNER_LIST)
        val bannerViewPager = banner_view as BannerViewPager<BannerBean>
        bannerViewPager
            .setIndicatorVisibility(View.GONE)
            .setLifecycleRegistry(lifecycle)
            .setIndicatorSlideMode(IndicatorSlideMode.SMOOTH)
            .setPageStyle(PageStyle.MULTI_PAGE_SCALE)
            //再MultiPageScale的模式下，左右各突出多少
            .setRevealWidth(30, 30)
            .setOnPageClickListener { clickedView: View?, position: Int ->
                //点击事件
                if (!list?.get(position)?.adUrl.isNullOrEmpty()){
                    startActivity(CommonUtils.toWeb(list?.get(position)?.adUrl))
                }
            }
            .setAdapter(HomeBannerAdapter()).create(list)
    }


    override fun lazyLoad() {
        presenter?.getMatchData(mPage)
        presenter?.getTopLive(mPage)
    }


    companion object {
        fun newInstance(id: String, title: String): MainContentAllFragment {
            val args = Bundle()
            val fragment = MainContentAllFragment()
            args.putString(CategoryBean.ID, id)
            args.putString(CategoryBean.TITLE, title)
            fragment.arguments = args
            return fragment
        }
    }

    @Subscribe(threadMode = ThreadMode.MAIN, sticky = true, priority = 1)
    fun onEventContent(event: SubscribeEvent) {
        if (event.className == Constants.SUBSCRIBE_TOP) {
            if (SPUtil[Constants.USER_LOGIN, false] == true) {
                presenter?.reserveMatch(event.id, event.isStatus)
            } else {
                DialogUtils.showLogin(activity as AppCompatActivity)
            }
        }

    }


    override fun onRequestLiveData(data: List<LiveBean.DataListBean>?) {
        mStatusLayoutManager.showSuccessLayout()
        liveItemAdapter?.let {
            setLoadMore(it, data)
        }
    }

    override fun onTopLiveData(data: List<MatchInfosBean>?) {
        mStatusLayoutManager.showSuccessLayout()
        liveTopAdapter?.let {
            setLoadMore(it, data, false)
        }
    }

    override fun onSubscribeMatch(id: String, status: Boolean) {
        ToastUtil.s(if (status) "预约成功" else "取消成功")
        liveTopAdapter?.data?.forEachIndexed { position, bean ->
            if (bean.id == id) {
                bean.isSubscribe = status
                liveTopAdapter?.notifyItemChanged(position)
            }
        }
    }


    override fun onDestroy() {
        EventBus.getDefault().unregister(this)
        super.onDestroy()
    }

    override fun onDestroyView() {
        super.onDestroyView()
        EventBus.getDefault().unregister(this)
    }
}