package com.hupu.tv.player.app.ui.fragment

import android.content.Intent
import android.os.Bundle
import android.view.View
import androidx.appcompat.app.AppCompatActivity
import androidx.recyclerview.widget.GridLayoutManager

import com.mirkowu.basetoolbar.BaseToolbar
import com.softgarden.baselibrary.utils.L
import com.softgarden.baselibrary.utils.RecyclerViewUtil
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.base.RefreshFragment
import com.hupu.tv.player.app.base.RefreshVP2Fragment
import com.hupu.tv.player.app.base.ToolbarFragment
import com.hupu.tv.player.app.bean.CategoryBean
import com.hupu.tv.player.app.bean.LiveBean
import com.hupu.tv.player.app.bean.MatchContentBean
import com.hupu.tv.player.app.bean.MovieBean
import com.hupu.tv.player.app.event.VisibleEvent
import com.hupu.tv.player.app.ui.activity.LiveActivity
import com.hupu.tv.player.app.ui.activity.MineBuyVipActivity
import com.hupu.tv.player.app.ui.activity.NewMatchDetailActivity
import com.hupu.tv.player.app.ui.adapter.LiveItemAdapter
import com.hupu.tv.player.app.ui.contact.MainContentNormalContract
import com.hupu.tv.player.app.ui.presenter.MainContentNormalPresenter
import com.hupu.tv.player.app.utils.CommonUtils
import com.hupu.tv.player.app.utils.DialogUtils
import com.hupu.tv.player.app.widget.ImageCarousel
import com.softgarden.baselibrary.utils.SPUtil
import org.greenrobot.eventbus.EventBus
import org.greenrobot.eventbus.Subscribe
import org.greenrobot.eventbus.ThreadMode

/**
 * @author by Dell
 * @date on 2020/6/14
 * @describe
 */
class MainContentNormalFragment : RefreshFragment<MainContentNormalPresenter>(), MainContentNormalContract.Display {
    private var liveItemAdapter: LiveItemAdapter? = null
    private var sportId: String = ""
    override val layoutId: Int
        get() = R.layout.fragment_match_content_normal



    override fun initEventAndData() {
        initRefreshLayout()
        initRecyclerView()
        initView()
        initStatusLayout(mRefreshLayout as View)
        mStatusLayoutManager.showLoadingLayout()
    }

    private fun initView() {
        liveItemAdapter = LiveItemAdapter()
        mRecyclerView?.adapter = liveItemAdapter
        mRecyclerView?.layoutManager = GridLayoutManager(activity, 2)
        activity?.let { RecyclerViewUtil.addGridItemDecoration(it, mRecyclerView!!, R.color.transparent, 2 * Constants.item_divider_4) }
        liveItemAdapter?.setOnItemClickListener { adapter, view, position ->
            val item:LiveBean.DataListBean = adapter.getItem(position) as LiveBean.DataListBean
            val intent = Intent(activity, LiveActivity::class.java)
            intent.putExtra(Constants.ROOM_ID,item.roomId)
            intent.putExtra(Constants.ROOM_COVER,item.matchCutImg)
            startActivity(intent)

        }

        arguments?.getString(CategoryBean.ID)?.let {
            sportId = it
        }

    }



    override fun lazyLoad() {
        presenter?.getMatchData(sportId,mPage)
    }



    companion object {
        fun newInstance(id: String,title:String): MainContentNormalFragment {
            val args = Bundle()
            val fragment = MainContentNormalFragment()
            args.putString(CategoryBean.ID, id)
            args.putString(CategoryBean.TITLE, title)
            fragment.arguments = args
            return fragment
        }
    }


    override fun onMatchRequest(data: List<LiveBean.DataListBean>?) {
        mStatusLayoutManager.showSuccessLayout()

        liveItemAdapter?.let {
            setLoadMore(it, data)
        }
    }
}