package com.hupu.tv.player.app.ui.fragment

import android.content.Intent
import android.os.Bundle

import android.view.View
import androidx.appcompat.app.AppCompatActivity
import androidx.fragment.app.Fragment
import cc.taylorzhang.singleclick.onSingleClick
import com.flyco.tablayout.utils.FragmentBasePager2Adapter
import com.kongzue.dialog.v3.WaitDialog
import com.softgarden.baselibrary.base.FragmentBaseStatePagerAdapter
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.base.RefreshFragment
import com.hupu.tv.player.app.bean.LiveUserBean
import com.hupu.tv.player.app.bean.TitleSortBean
import com.hupu.tv.player.app.ui.activity.MainActivity
import com.hupu.tv.player.app.ui.activity.MessageActivity
import com.hupu.tv.player.app.ui.activity.SearchActivity
import com.hupu.tv.player.app.ui.contact.MainFragmentContact
import com.hupu.tv.player.app.ui.presenter.MainFragmentPresenter
import com.hupu.tv.player.app.ui.presenter.SearchActivityPresenter
import com.hupu.tv.player.app.utils.DialogUtils
import com.hupu.tv.player.app.utils.GlideUtils
import com.softgarden.baselibrary.utils.SPUtil
import kotlinx.android.synthetic.main.fragment_main.*
import kotlin.collections.ArrayList


/**
 * @author by DELL
 * @date on 2020/06/11
 * @describe
 */
class MainFragment : RefreshFragment<MainFragmentPresenter>(), MainFragmentContact.Display {

    override val layoutId: Int
        get() = R.layout.fragment_main

    override fun lazyLoad() {
        presenter?.getCategory()
        presenter?.getShowConfig()
    }

    private fun initViewPager() {
        val mFragments = ArrayList<Fragment>()
        val list = addDefaultData()
        val mTitles = arrayOfNulls<String>(list.size)
        list.forEachIndexed { index, titleSortBean ->
            mTitles[index] = titleSortBean.sportsName
            if (titleSortBean.sportsId == Constants.MATCH_ALL) {
                mFragments.add(
                    MainContentAllFragment.newInstance(
                        titleSortBean.sportsId,
                        titleSortBean.sportsName
                    )
                )
            } else {
                mFragments.add(
                    MainContentNormalFragment.newInstance(
                        titleSortBean.sportsId,
                        titleSortBean.sportsName
                    )
                )
            }
        }

        val mAdapter = FragmentBaseStatePagerAdapter(childFragmentManager, mFragments, mTitles)
        vp_main.offscreenPageLimit = list.size
        vp_main.adapter = mAdapter
        tabLayout_main.setViewPager(vp_main)
    }

    private fun addDefaultData(): ArrayList<TitleSortBean> {
        val arrayList = ArrayList<TitleSortBean>()
        val titleSortBean = TitleSortBean()
        titleSortBean.sportsId = Constants.MATCH_ALL
        titleSortBean.sportsName = Constants.MATCH_ALL_TEXT
        arrayList.add(titleSortBean)
        val titleSortBean1 = TitleSortBean()
        titleSortBean1.sportsId = Constants.MATCH_FOOTBALL
        titleSortBean1.sportsName = Constants.MATCH_FOOTBALL_TEXT
        arrayList.add(titleSortBean1)
        val titleSortBean2 = TitleSortBean()
        titleSortBean2.sportsId = Constants.MATCH_BASKETBALL
        titleSortBean2.sportsName = Constants.MATCH_BASKETBALL_TEXT
        arrayList.add(titleSortBean2)
        val titleSortBean3 = TitleSortBean()
        titleSortBean3.sportsId = Constants.MATCH_OTHER
        titleSortBean3.sportsName = Constants.MATCH_OTHER_TEXT
        arrayList.add(titleSortBean3)

        return arrayList
    }


    companion object {
        @JvmStatic
        fun newInstance(): MainFragment {
            val args = Bundle()
            val fragment = MainFragment()
            fragment.arguments = args
            return fragment
        }
    }

    override fun onCategoryResponse() {
        mStatusLayoutManager.showSuccessLayout()
        initViewPager()
//        SPUtil.put(Constants.SHOW_LIVE_CONFIG, true)
    }

    override fun showError(throwable: Throwable,isConfigStatus:Boolean) {
        super.showError(throwable,isConfigStatus)
        mStatusLayoutManager.showErrorLayout()
    }

    override fun initEventAndData() {
        initListener()
        initStatusLayout(ll_root as View)
        mStatusLayoutManager.showLoadingLayout()
    }

    private fun initListener() {
        (requireActivity() as MainActivity).setAvatar(iv_avatar)

        iv_avatar.onSingleClick{
            (requireActivity() as MainActivity).toMineFragment()
        }


        iv_message.onSingleClick {
            if (SPUtil[Constants.USER_LOGIN, false] == true) {
                startActivity(Intent(requireContext(), MessageActivity::class.java))
            } else {
                DialogUtils.showLogin(requireActivity() as AppCompatActivity)
            }

        }
        rl_search.onSingleClick {
            startActivity(Intent(requireContext(), SearchActivity::class.java))
        }
    }
}