package com.hupu.tv.player.app.ui.fragment

import android.content.Intent
import android.os.Bundle

import android.view.View
import androidx.fragment.app.Fragment
import cc.taylorzhang.singleclick.onSingleClick
import com.flyco.tablayout.utils.FragmentBasePager2Adapter
import com.mirkowu.basetoolbar.BaseToolbar
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.base.RefreshFragment
import com.hupu.tv.player.app.base.ToolbarFragment
import com.hupu.tv.player.app.bean.*
import com.hupu.tv.player.app.ui.activity.MainActivity
import com.hupu.tv.player.app.ui.activity.SearchSpecialistActivity
import com.hupu.tv.player.app.ui.activity.SpecialistDetailActivity
import com.hupu.tv.player.app.ui.adapter.HaveMaterialMatchAdapter
import com.hupu.tv.player.app.ui.adapter.HaveMaterialSpecialistAdapter
import com.hupu.tv.player.app.ui.adapter.HomeBannerAdapter
import com.hupu.tv.player.app.ui.contact.MainHaveMaterialContract
import com.hupu.tv.player.app.ui.presenter.MainHaveMaterialPresenter
import com.hupu.tv.player.app.utils.GlideUtils
import com.hupu.tv.player.app.utils.VersionControl
import com.softgarden.baselibrary.utils.SPUtil
import com.zhpan.bannerview.BannerViewPager
import com.zhpan.bannerview.constants.PageStyle
import com.zhpan.indicator.enums.IndicatorSlideMode
import kotlinx.android.synthetic.main.fragment_main_have_material.*
import kotlinx.android.synthetic.main.layout_empty.*
import org.greenrobot.eventbus.Subscribe
import org.greenrobot.eventbus.ThreadMode


/**
 * @author by Dell
 * @date on 2020/6/15
 * @describe
 */
class MainHaveMaterialFragment : RefreshFragment<MainHaveMaterialPresenter>(), MainHaveMaterialContract.Display {
    private var type = 0
    private var mFragments = ArrayList<Fragment>()
    private lateinit var mAdapter: HaveMaterialSpecialistAdapter
    override val layoutId: Int
        get() = R.layout.fragment_main_have_material


    private fun initViewPager(list: List<TitleSortBean>) {
        mFragments.clear()
        val mTitles = arrayOfNulls<String>(list.size)
        list.forEachIndexed { index, titleSortBean ->
            mTitles[index] = titleSortBean.sportsName
            mFragments.add(
                HaveMaterialFragment.newInstance(
                    titleSortBean.sportsId,
                    titleSortBean.sportsName
                )
            )

        }

        val fragmentAdapter =
            FragmentBasePager2Adapter(childFragmentManager, mFragments, mTitles, lifecycle)
        vp_have_material.adapter = fragmentAdapter
        tabLayout_material.setViewPager2(vp_have_material)
    }

    override fun onBanner(data: ArrayList<BannerBean>?) {
        initBanner(data)
    }

    private fun initBanner(data: java.util.ArrayList<BannerBean>?) {
        val bannerViewPager = banner_view as BannerViewPager<BannerBean>
        bannerViewPager
            .setIndicatorVisibility(View.GONE)
            .setLifecycleRegistry(lifecycle)
            .setIndicatorSlideMode(IndicatorSlideMode.SMOOTH)
            .setPageStyle(PageStyle.MULTI_PAGE_SCALE)
            //再MultiPageScale的模式下，左右各突出多少
            .setRevealWidth(30, 30)
            .setOnPageClickListener { clickedView: View?, position: Int ->
                //点击事件
            }
            .setAdapter(HomeBannerAdapter()).create(data)
    }

    override fun onSpecialist(data: MutableList<SpecialistBean>?) {
        setLoadData(mAdapter, data)
    }

    override fun onSchedule(data: MutableList<MaterialScheduleItemEntity>?) {
        if (data?.size ?: 0 > 0) {
            ll_schedule.visibility = View.VISIBLE
            recycler_schedule.apply {
                adapter = HaveMaterialMatchAdapter().apply {
                    setLoadMore(recycler_schedule, this, data)
                }
            }
            ll_schedule_top.onSingleClick {
                (activity as? MainActivity)?.topMatch()
            }
        }
    }


    companion object {
        @JvmStatic
        fun newInstance(): MainHaveMaterialFragment {
            val args = Bundle()
            val fragment = MainHaveMaterialFragment()
            fragment.arguments = args
            return fragment
        }
    }

    override fun initEventAndData() {
        initRecyclerView()
        initListener()
        initAdapter()
        initViewPager(defaultList())
        setButton()

    }

    private fun initAdapter() {
        mRecyclerView?.apply {
            mAdapter = HaveMaterialSpecialistAdapter().apply {
                setOnItemClickListener { adapter, view, position ->
                    startActivity(
                        Intent(
                            requireContext(),
                            SpecialistDetailActivity::class.java
                        ).apply {
                            putExtra(
                                Constants.SPECIALIST_ID,
                                (adapter.getItem(position) as SpecialistBean).anchorId
                            )
                        })
                }
            }
            adapter = mAdapter
        }
    }


    private fun initListener() {
        (requireActivity() as MainActivity).setAvatar(iv_avatar_have, false)
        iv_avatar_have.onSingleClick {
            (requireActivity() as MainActivity).toMineFragment()
        }

        iv_search.onSingleClick {
            startActivity(Intent(requireContext(), SearchSpecialistActivity::class.java))
        }

        tv_famous_scholars.onSingleClick {
            type = 0
            setButton()
            presenter?.getSpecialist(type)
        }
        tv_win_rate.onSingleClick {
            type = 1
            setButton()
            presenter?.getSpecialist(type)
        }
        tv_continue_red.onSingleClick {
            type = 2
            setButton()
            presenter?.getSpecialist(type)
        }

    }

    private fun setButton() {


        tv_famous_scholars.isSelected = false
        tv_win_rate.isSelected = false
        tv_continue_red.isSelected = false
        when (type) {
            0 -> tv_famous_scholars.isSelected = true
            1 -> tv_win_rate.isSelected = true
            2 -> tv_continue_red.isSelected = true
        }
    }

//    override fun showError(throwable: Throwable) {
//        super.showError(throwable)
//        mStatusLayoutManager.showErrorLayout()
//    }


    override fun lazyLoad() {
        if (!VersionControl.showRedList()) {
            ll_empty.visibility = View.VISIBLE
        }
        presenter?.getSpecialist(type)
        presenter?.getBanner()
        presenter?.getSchedule(mPage, PAGE_COUNT)
    }

    private fun defaultList(): MutableList<TitleSortBean> {
        return mutableListOf<TitleSortBean>().apply {
            add(TitleSortBean().apply {
                sportsName = Constants.MATCH_FOOTBALL_TEXT
                sportsId = Constants.SPORT_TYPE_FOOTBALL.toString()
            })

            add(TitleSortBean().apply {
                sportsName = Constants.MATCH_BASKETBALL_TEXT
                sportsId = Constants.SPORT_TYPE_BASKETBALL.toString()
            })

        }
    }
}