package com.hupu.tv.player.app.ui.fragment

import android.content.Intent
import android.os.Bundle
import android.view.View
import androidx.recyclerview.widget.LinearLayoutManager


import com.mirkowu.basetoolbar.BaseToolbar
import com.softgarden.baselibrary.utils.L
import com.softgarden.baselibrary.utils.RecyclerViewUtil

import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.base.RefreshVP2Fragment
import com.hupu.tv.player.app.base.ToolbarFragment
import com.hupu.tv.player.app.bean.*
import com.hupu.tv.player.app.event.RefreshNewsEvent
import com.hupu.tv.player.app.event.VisibleEvent
import com.hupu.tv.player.app.ui.activity.NewsDetailActivity
import com.hupu.tv.player.app.ui.adapter.HomeBannerAdapter
import com.hupu.tv.player.app.ui.adapter.NewsListAdapter
import com.hupu.tv.player.app.ui.contact.MainNewsContentAllContract
import com.hupu.tv.player.app.ui.presenter.MainNewsContentAllPresenter
import com.hupu.tv.player.app.utils.CommonUtils
import com.hupu.tv.player.app.widget.ImageCarousel
import com.softgarden.baselibrary.utils.SPUtil
import com.softgarden.baselibrary.utils.ToastUtil
import com.zhpan.bannerview.BannerViewPager
import com.zhpan.bannerview.constants.PageStyle
import com.zhpan.bannerview.utils.BannerUtils
import com.zhpan.indicator.enums.IndicatorSlideMode
import kotlinx.android.synthetic.main.fragment_news_all.*
import org.greenrobot.eventbus.EventBus
import org.greenrobot.eventbus.Subscribe
import org.greenrobot.eventbus.ThreadMode

/**
 * @author by Dell
 * @date on 2020/6/14
 * @describe
 */
class MainNewsContentAllFragment : RefreshVP2Fragment<MainNewsContentAllPresenter>(),
    MainNewsContentAllContract.Display {
    private var tagId: String = ""
    private lateinit var newsAdapter: NewsListAdapter
    override val layoutId: Int
        get() = R.layout.fragment_news_all


    override fun initEventAndData() {
        initRefreshLayout()
        initRecyclerView()
        initView()
        initStatusLayout(mRecyclerView!!)
        mStatusLayoutManager.showLoadingLayout()
    }

    private fun initView() {
        tagId = arguments?.getString(CategoryBean.ID).orEmpty()
        initBanner()
        initAdapter()

    }

//    @Subscribe(threadMode = ThreadMode.MAIN)
//    fun onRefreshNews(event:RefreshNewsEvent){
//        onRefresh()
//    }

    private fun initAdapter() {
        newsAdapter = NewsListAdapter()
        mRecyclerView?.layoutManager = LinearLayoutManager(requireContext())
        activity?.let {
            RecyclerViewUtil.addItemDecoration(
                it,
                mRecyclerView!!,
                R.color.transparent,
                Constants.item_divider_4*2,
            )
        }
        mRecyclerView?.adapter = newsAdapter
        newsAdapter.setOnItemClickListener { adapter, view, position ->
            val intent = Intent(requireActivity(), NewsDetailActivity::class.java)
            val bean = adapter.getItem(position) as? NewsListEntity
            intent.putExtra(Constants.NEWS_DETAIL, bean?.id?.toString())
            startActivity(intent)
        }
    }

    private fun initBanner() {
        val list = SPUtil.getSerializableObject<ArrayList<BannerBean>>(Constants.NEWS_HEAD_LIST)

        val bannerViewPager = banner_view as BannerViewPager<BannerBean>
        bannerViewPager
            .setIndicatorVisibility(View.GONE)
            .setLifecycleRegistry(lifecycle)
            .setIndicatorSlideMode(IndicatorSlideMode.SMOOTH)
            .setPageStyle(PageStyle.MULTI_PAGE_SCALE)
            //再MultiPageScale的模式下，左右各突出多少
            .setRevealWidth(30, 30)
            .setOnPageClickListener { clickedView: View?, position: Int ->
                //点击事件
                if (!list?.get(position)?.adUrl.isNullOrEmpty()){
                    startActivity(CommonUtils.toWeb(list?.get(position)?.adUrl))
                }

            }
            .setAdapter(HomeBannerAdapter(true)).create(list)
    }
    override fun lazyLoad() {
        presenter?.getNewsList(tagId, mPage)

    }


    companion object {
        fun newInstance(id: String?, title: String?): MainNewsContentAllFragment {
            val args = Bundle()
            val fragment = MainNewsContentAllFragment()
            args.putString(CategoryBean.ID, id)
            args.putString(CategoryBean.TITLE, title)
            fragment.arguments = args
            return fragment
        }
    }

    override fun onNewsData(data: NewsDataBean?) {
        setLoadMore(newsAdapter, data?.dataList)
        mStatusLayoutManager.showSuccessLayout()

    }

}