package com.hupu.tv.player.app.ui.fragment

import android.content.Intent
import android.os.Bundle
import android.view.View
import androidx.recyclerview.widget.LinearLayoutManager

import com.mirkowu.basetoolbar.BaseToolbar
import com.softgarden.baselibrary.utils.RecyclerViewUtil
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.base.RefreshVP2Fragment
import com.hupu.tv.player.app.base.ToolbarFragment
import com.hupu.tv.player.app.bean.*
import com.hupu.tv.player.app.ui.activity.NewsDetailActivity
import com.hupu.tv.player.app.ui.adapter.NewsListAdapter
import com.hupu.tv.player.app.ui.contact.MainNewsContentNormalContract
import com.hupu.tv.player.app.ui.presenter.MainNewsContentNormalPresenter
import com.softgarden.baselibrary.network.ApiException
import kotlinx.android.synthetic.main.fragment_news_normal.*

/**
 * @author by Dell
 * @date on 2020/6/14
 * @describe
 */
class MainNewsContentNormalFragment : RefreshVP2Fragment<MainNewsContentNormalPresenter>(), MainNewsContentNormalContract.Display {
    private var tagId: String = ""
    private lateinit var newsAdapter: NewsListAdapter
    override val layoutId: Int
        get() = R.layout.fragment_news_normal


    override fun initEventAndData() {

        initRefreshLayout()
        initRecyclerView()
        initView()
        initStatusLayout(mRefreshLayout as View)
        mStatusLayoutManager.showLoadingLayout()
    }

    private fun initView() {
        newsAdapter = NewsListAdapter()
        mRecyclerView?.layoutManager = LinearLayoutManager(requireContext())
        activity?.let { RecyclerViewUtil.addItemDecoration(it, mRecyclerView!!, R.color.transparent, Constants.item_divider_4*2) }
        mRecyclerView?.adapter = newsAdapter
        newsAdapter.setOnItemClickListener { adapter, view, position ->
            val intent = Intent(requireActivity(), NewsDetailActivity::class.java)
            val bean = adapter.getItem(position) as? NewsListEntity
            intent.putExtra(Constants.NEWS_DETAIL,bean?.id?.toString())
            startActivity(intent)
        }

        arguments?.getString(CategoryBean.ID)?.let {
            tagId = it
        }
    }

    override fun lazyLoad() {
        presenter?.getNewsList(tagId, mPage)
    }


    companion object {
        fun newInstance(id: String?, title: String?): MainNewsContentNormalFragment {
            val args = Bundle()
            val fragment = MainNewsContentNormalFragment()
            args.putString(CategoryBean.ID, id)
            args.putString(CategoryBean.TITLE, title)
            fragment.arguments = args
            return fragment
        }
    }

    override fun showError(throwable: Throwable,isConfigStatus:Boolean) {
        super.showError(throwable,isConfigStatus)
        mStatusLayoutManager.showErrorLayout()
    }

    override fun onNewsData(data: NewsDataBean?) {
        setLoadMore(newsAdapter,data?.dataList)
        mStatusLayoutManager.showSuccessLayout()
    }

}