package com.hupu.tv.player.app.ui.fragment

import android.os.Bundle

import android.view.View
import androidx.appcompat.app.AppCompatActivity
import androidx.fragment.app.Fragment
import com.flyco.tablayout.utils.FragmentBasePager2Adapter
import com.kongzue.dialog.v3.WaitDialog
import com.softgarden.baselibrary.base.FragmentBaseStatePagerAdapter
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.base.RefreshFragment
import com.hupu.tv.player.app.base.RefreshVP2Fragment
import com.hupu.tv.player.app.bean.NewsTagItemEntity
import com.hupu.tv.player.app.ui.contact.MainNewsFragmentContact
import com.hupu.tv.player.app.ui.presenter.MainNewsFragmentPresenter
import kotlinx.android.synthetic.main.fragment_main_news.*
import kotlin.collections.ArrayList


/**
 * @author by DELL
 * @date on 2020/06/11
 * @describe
 */
class MainNewsFragment : RefreshFragment<MainNewsFragmentPresenter>(), MainNewsFragmentContact.Display {
    override val layoutId: Int
        get() = R.layout.fragment_main_news

    override fun lazyLoad() {
        presenter?.getCategory()
    }


    companion object {
        @JvmStatic
        fun newInstance(): MainNewsFragment {
            val args = Bundle()
            val fragment = MainNewsFragment()
            fragment.arguments = args
            return fragment
        }
    }


    override fun onTagList(data: List<NewsTagItemEntity>?) {
        if (data?.size == 0){
            mStatusLayoutManager.showErrorLayout()
            return
        }
        mStatusLayoutManager.showSuccessLayout()
        val mFragments = ArrayList<Fragment>()
        val mTitles = arrayOfNulls<String>(data?.size ?: 0)
        data?.forEachIndexed { index, bean ->
            mTitles[index] = bean.tagName
            if (bean.tagName!="热门"){
                mFragments.add(MainNewsContentNormalFragment.newInstance(bean.tagId.toString(), bean.tagName))
            }else{
                mFragments.add(MainNewsContentAllFragment.newInstance(bean.tagId.toString(), bean.tagName))
            }

        }

        val mAdapter = FragmentBasePager2Adapter(childFragmentManager, mFragments, mTitles,lifecycle)
        vp_main.offscreenPageLimit = data?.size ?: 0
        vp_main.adapter = mAdapter
        tabLayout_main.setViewPager2(vp_main)
    }

    override fun showError(throwable: Throwable,isConfigStatus:Boolean) {
        super.showError(throwable,isConfigStatus)
        mStatusLayoutManager.showErrorLayout()
    }

    override fun initEventAndData() {
        initStatusLayout(ll_root as View)
        mStatusLayoutManager.showLoadingLayout()
    }
}