package com.hupu.tv.player.app.ui.fragment

import android.os.Bundle
import android.os.CountDownTimer

import android.text.Html
import android.view.View
import android.view.animation.AnimationUtils
import android.widget.ImageView
import android.widget.LinearLayout
import android.widget.TextView
import androidx.appcompat.app.AppCompatActivity
import com.bumptech.glide.Glide
import com.bumptech.glide.integration.recyclerview.RecyclerViewPreloader
import com.bumptech.glide.util.ViewPreloadSizeProvider
import com.chad.library.adapter.base.BaseViewHolder
import com.shuyu.gsyvideoplayer.GSYVideoManager
import com.softgarden.baselibrary.base.BaseActivity
import com.softgarden.baselibrary.utils.SPUtil
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.base.RefreshFragment
import com.hupu.tv.player.app.bean.MovieBean
import com.hupu.tv.player.app.bean.MovieDetailBean
import com.hupu.tv.player.app.event.RefreshPageEvent
import com.hupu.tv.player.app.event.RefreshVisibleEvent

import com.hupu.tv.player.app.ui.adapter.VideoAdapter
import com.hupu.tv.player.app.ui.contact.MainPagerFragmentContact
import com.hupu.tv.player.app.ui.presenter.MainPagerFragmentPresenter
import com.hupu.tv.player.app.utils.CommonUtils
import com.hupu.tv.player.app.utils.DialogUtils
import com.hupu.tv.player.app.utils.EmptyConfig
import com.hupu.tv.player.app.widget.CustomLayoutGSYVideoPlayer
import com.hupu.tv.player.app.widget.viewpager.viewpagerlayoutmanager.OnPlayerListener
import com.hupu.tv.player.app.widget.viewpager.viewpagerlayoutmanager.OnViewPagerListener
import com.hupu.tv.player.app.widget.viewpager.viewpagerlayoutmanager.ViewPagerLayoutManager
import kotlinx.android.synthetic.main.fragment_main_pager.*
import kotlinx.android.synthetic.main.layout_empty_no_data.*
import me.jessyan.autosize.utils.LogUtils
import org.greenrobot.eventbus.EventBus
import org.greenrobot.eventbus.Subscribe
import org.greenrobot.eventbus.ThreadMode


/**
 * @author by DELL
 * @date on 2020/06/11
 * @describe
 */
class MainPagerFragment : RefreshFragment<MainPagerFragmentPresenter>(), MainPagerFragmentContact.Display {
    private var adapter: VideoAdapter? = null
    private var mIsVisibleToUser: Boolean = false
    private var currentPlayer: CustomLayoutGSYVideoPlayer? = null
    private var viewPagerLayoutManager: ViewPagerLayoutManager? = null
    private var currentPosition = -1
    private var isNeedLoadData = true
    private var refreshData = false
    private var reloadData = -1
    override val layoutId: Int
        get() = R.layout.fragment_main_pager

    override fun lazyLoad() {
        //初始化，是对用户可见
        mIsVisibleToUser = true
        presenter?.getWinnerList()
        presenter?.getTikTokMovieList(mPage)

    }

    //最上方的filpper（马上赢钱需求）
    private fun initFlipper(data: List<String>?) {
        view_flipper.removeAllViews()
        for (flipperView in getFlipperView(data)) {
            view_flipper.addView(flipperView)
        }
        view_flipper.startFlipping()
        view_flipper.flipInterval = 4000
        view_flipper.inAnimation = AnimationUtils.loadAnimation(activity, R.anim.push_up_in)
        view_flipper.outAnimation = AnimationUtils.loadAnimation(activity, R.anim.push_up_out)
    }

    private fun getFlipperView(data: List<String>?): ArrayList<View> {
        val flipperViews: ArrayList<View> = arrayListOf()
        data?.forEach {
            val view = View.inflate(activity, R.layout.item_text_view_movie_image, null) as LinearLayout
            view.findViewById<TextView>(R.id.tv_content).text = Html.fromHtml(it)
            flipperViews.add(view)
        }
        return flipperViews
    }


    private fun initView() {
        //空布局，只针对tikTok接口的第一次
        ll_empty.visibility = View.GONE
        initRecyclerView()
        //上下滑动的viewpagerLayoutManager

        viewPagerLayoutManager = ViewPagerLayoutManager(activity)
        mRecyclerView?.layoutManager = viewPagerLayoutManager
        adapter = VideoAdapter(R.layout.video_item, activity as BaseActivity<*>?)
        adapter?.setEnableLoadMore(true)
        adapter?.setPreLoadNumber(5)
        adapter?.bindToRecyclerView(mRecyclerView)
        mRecyclerView?.adapter = adapter
        val glideRequest = Glide.with(this)

        adapter?.let {
            val preLoader = ViewPreloadSizeProvider<MovieBean.RecordsBean>()
            val recyclerViewPreload = RecyclerViewPreloader<MovieBean.RecordsBean>(Glide.with(activity!!), it, preLoader, 10)
            mRecyclerView?.addOnScrollListener(recyclerViewPreload)
            mRecyclerView?.setItemViewCacheSize(0)
            mRecyclerView?.setRecyclerListener { viewHolder ->
                viewHolder?.let { holder ->
                    if (holder is BaseViewHolder) {
                        val view = holder.getView<ImageView>(R.id.iv_cover)
                        if (view != null) {
                            glideRequest.clear(view)
                        }

                    }
                }


            }
        }

        adapter?.setOnPlayerListener(object : VideoAdapter.OnPlayerListener {
            //点击收藏
            override fun onLike(movieId: Int, position: Int) {
                val item = adapter?.getItem(position)
                presenter?.clickCollect(item?.id, position)
            }

            //倒计时完成
            override fun onFinish() {
                viewPagerLayoutManager?.isCanScroll = true
            }
        })
        adapter?.setOnItemChildClickListener { videoAdapter, view, position ->
            if (view.id == R.id.iv_full) {
//                val item = videoAdapter.getItem(position) as MovieBean.RecordsBean
//                val intent = Intent(activity, PlayDetailActivity2::class.java)
//                intent.putExtra(MovieBean.MOVIE_BEAN, item)
//                startActivity(intent)

            }
        }
        viewPagerLayoutManager?.setOnViewPagerListener(object : OnViewPagerListener {
            override fun onInitComplete(position: Int) {
                LogUtils.e("PagerLayout onInitComplete position:$position")
                //初始化，position为1，这个init在滑动的过程中，只调用一次，单独处理
                currentPosition = position
                //下一个position
                val nextPosition = position + 1
                val item = adapter?.getItem(position)
                val nextItem = adapter?.getItem(nextPosition)
                val id = item?.id
                val next = nextItem?.id
                //归为默认值
                restorePlayAdapter(position)
                adapter?.getViewByPosition(position, R.id.player)?.let {
                    if (it is CustomLayoutGSYVideoPlayer) {
                        //获取adapter对应的播放器
                        currentPlayer = it
                        currentPlayer?.isClickPlayer = true

                        //设置播放监听，去掉封面
                        it.setOnClickStartButton(object : CustomLayoutGSYVideoPlayer.OnClickStartButton {
                            override fun onStart() {
                                LogUtils.e("PagerLayout onInitComplete onStart:$position")
                                adapter?.getViewByPosition(position, R.id.iv_cover)?.let { cover ->
                                    val recordsBean = adapter?.getItem(position) as MovieBean.RecordsBean
                                    if (recordsBean.isPlayFullUrl) {
                                        presenter?.moviePlay(id)
                                    }
                                    LogUtils.e("PagerLayout onInitComplete cover:$cover")
                                    cover.postDelayed({
                                        cover.visibility = View.GONE
                                        LogUtils.e("PagerLayout onInitComplete currentState:${it.currentState}")
                                    }, 500)
                                }
                            }
                        })
                        //获取对应的movieDetail，判断是否能播放
                        presenter?.getMovieDetail(id, position)
                        presenter?.getMovieDetail(next, nextPosition)
                    }
                }
            }

            override fun onPageRelease(isNext: Boolean, position: Int) {
                LogUtils.e("PagerLayout release position:$position")
                //释放，停止播放
                adapter?.getViewByPosition(position, R.id.player)?.let {
                    if (it is CustomLayoutGSYVideoPlayer) {
                        adapter?.getViewByPosition(position, R.id.iv_cover)?.let { cover ->
                            cover.visibility = View.VISIBLE
                        }
                        it.release()
                    }
                }
            }

            override fun onPageSelected(position: Int, isBottom: Boolean, isDown: Boolean) {
                LogUtils.e("PagerLayout selected position$position")
                if (currentPosition == position) {
                    return
                }
                currentPosition = position


                pageSelected(isDown, position)
            }
        })
        ll_save_money.setOnClickListener {
//            startActivity(MineBuyVipActivity::class.java)
            startActivity(CommonUtils.toWeb(SPUtil[Constants.JUMP_WIN_URL, ""] as String))
        }
    }

    /**
     * 判断当选中之后的逻辑
     */
    private fun pageSelected(isDown: Boolean, position: Int) {

        //下一个预加载的是上面还是下面
        val nextPosition = if (isDown) {
            position + 1
        } else {
            position - 1
        }
        currentPosition = position

        val item = adapter?.getItem(position)

        val id = item?.id
        //是否已经请求过了
        val request = item?.isRequest ?: false
        //当前的player
        adapter?.getViewByPosition(position, R.id.player)?.let {
            if (it is CustomLayoutGSYVideoPlayer) {
                currentPlayer = it
                //归为默认值
                currentPlayer?.isClickPlayer = true
                it.setOnClickStartButton(object : CustomLayoutGSYVideoPlayer.OnClickStartButton {
                    override fun onStart() {
                        adapter?.getViewByPosition(position, R.id.iv_cover)?.let { cover ->
                            cover.postDelayed({
                                val recordsBean = adapter?.getItem(position) as MovieBean.RecordsBean
                                if (recordsBean.isPlayFullUrl) {
                                    presenter?.moviePlay(id)
                                }
                                cover.visibility = View.GONE
                                LogUtils.e("PagerLayout onSelected currentState:${it.currentState}")
                            }, 100)
                        }
                    }
                })
                //没有请求过，并且不是广告
                if (item != null && !request && item.tagId != Constants.AD_MOVIE_ITEM_PICTURE && item.tagId != Constants.AD_MOVIE_ITEM_VIDEO) {
                    LogUtils.e("viewPagerLayout tagId${item.tagId}")
                    presenter?.getMovieDetail(id, position)
                }

                //如果已经请求，并且可以播放，播放
                isCanPlay(request, item, it, position)

                //如果没有请求过，请求当前的Detail

                //下一个position，如果不是-1（超出边界，提前请求）
                adapter?.data?.size?.let { size ->
                    LogUtils.e("viewPagerLayout dataSize:${adapter?.data?.size}")
                    if (nextPosition != -1 && nextPosition <= size) {
                        val nextItem = adapter?.getItem(nextPosition)
                        if (nextItem?.tagId == Constants.AD_MOVIE_ITEM_PICTURE) {
                            isAdPlayer(isDown, position)
                        } else {
                            val next = nextItem?.id
                            val requestNext = nextItem?.isRequest ?: false
                            if (nextItem != null && !requestNext && nextItem.tagId != Constants.AD_MOVIE_ITEM_PICTURE && nextItem.tagId != Constants.AD_MOVIE_ITEM_VIDEO) {
                                LogUtils.e("viewPagerLayout Next No tagId${nextItem?.tagId}")
                                presenter?.getMovieDetail(next, nextPosition)
                            }
                        }


                    }
                }


            }
        }
    }

    /**
     * 是广告的情况下
     */
    private fun isAdPlayer(isDown: Boolean, position: Int) {
        val newNextPosition = if (isDown) {
            position + 2
        } else {
            position - 2
        }
        adapter?.data?.size?.let { size ->
            if (newNextPosition != -1 && newNextPosition <= size) {
                val newNextItem = adapter?.getItem(newNextPosition)
                val next = newNextItem?.id
                val requestNext = newNextItem?.isRequest ?: false
                if (!requestNext) {
                    LogUtils.e("viewPagerLayout Next new tagId${newNextItem?.tagId}")
                    presenter?.getMovieDetail(next, newNextPosition)
                }
            }
        }
    }

    /**
     * 播放控制
     */
    private fun isCanPlay(request: Boolean?, item: MovieBean.RecordsBean?, it: CustomLayoutGSYVideoPlayer?, position: Int) {
        LogUtils.e("viewPagerLayout tagId = ${item?.tagId}")
        //恢复Recycler的各种监听
        restorePlayAdapter(position)
        if (request == true) {
            if (item?.isPlayFullUrl == false || item?.isCanPlay == true) {
//                ToastUtil.s("isFull${item.isPlayFullUrl}====isCanPlay${item.isCanPlay}" )
                currentPlayer?.isClickPlayer = true
                currentPlayer?.isCanPlay = true
                it?.startPlayLogic()
            }else {
                currentPlayer?.isCanPlay = false
                currentPlayer?.isClickPlayer = false
                adapter?.getViewByPosition(position, R.id.iv_cover)?.let { cover ->
                    cover.setOnClickListener {
                        showRechargeDialog(item?.buyGoldCoin)
                    }
                }
                showRechargeDialog(item?.buyGoldCoin)
            }
            //如果是广告，播放，并且不能滑动
        } else if (item?.tagId == Constants.AD_MOVIE_ITEM_VIDEO) {
            //视频广告,不能滑动
            viewPagerLayoutManager?.isCanScroll = false
            //正常播放
            it?.startPlayLogic()
            //isClickPlayer，只针对于正常视频，其他视频为false
            currentPlayer?.isClickPlayer = false
            //设置点击屏幕的监听（此时点击屏幕自行处理，不是暂停）
            currentPlayer?.setOnPlayerListener(object : OnPlayerListener {
                override fun onClickScreen() {
                    startActivity(CommonUtils.toWeb(SPUtil[Constants.YB_URL, ""] as String))
                }
            })
            //广告加上倒计时，倒计时结束后可以滑动
            showAdCountDown(position)


        } else if (item?.tagId == Constants.AD_MOVIE_ITEM_PICTURE) {
            viewPagerLayoutManager?.isCanScroll = false

            adapter?.getViewByPosition(position, R.id.iv_cover)?.let { cover ->
                cover.setOnClickListener {
//                    startActivity(CommonUtils.toWeb(item.videoUrl))
                    startActivity(CommonUtils.toWeb(SPUtil[Constants.YB_URL, ""] as String))
                }
            }
            showAdCountDown(position)
        } else if (item != null && request == false && item.tagId != Constants.AD_MOVIE_ITEM_PICTURE && item.tagId != Constants.AD_MOVIE_ITEM_VIDEO) {
            //连续滑动比较快，没有请求
            reloadData = position
            presenter?.getMovieDetail(item.id, position)

        } else {
            //不能播放（正常视频）
            currentPlayer?.isClickPlayer = false
            //不响应暂停播放逻辑，出现提示框
            adapter?.getViewByPosition(position, R.id.iv_cover)?.let { cover ->
                cover.setOnClickListener {
//                    startActivity(CommonUtils.toWeb(item.videoUrl))
                    showRechargeDialog(item?.buyGoldCoin)
                }
            }
            showRechargeDialog(item?.buyGoldCoin)
            LogUtils.e("viewPagerLayout noPlay request$request isCanPlay${item?.isCanPlay} tagId${item?.tagId}")
        }

    }

    private fun restorePlayAdapter(position: Int) {
        adapter?.getViewByPosition(position, R.id.iv_cover)?.let { cover ->
            cover.setOnClickListener(null)
        }
        currentPlayer?.isClickPlayer = true
        currentPlayer?.isCanPlay = false
        currentPlayer?.setOnPlayerListener(null)
        reloadData = -1
    }

    private fun showAdCountDown(position: Int) {
        val tvAdCover = adapter?.getViewByPosition(position, R.id.tv_ad_cover) as TextView
        tvAdCover.visibility = View.VISIBLE
        activity?.let { activity ->
            tvAdCover.text = String.format(activity.getString(R.string.string_ad_time_tik_tok, 4))
            object : CountDownTimer(4000, 1000) {
                override fun onFinish() {
                    //监听结束之后，可以滑动
                    viewPagerLayoutManager?.isCanScroll = true
                    tvAdCover.visibility = View.GONE
                }

                override fun onTick(p0: Long) {
                    tvAdCover.text = String.format(activity.getString(R.string.string_ad_time_tik_tok, p0.toInt() / 1000))
                }
            }.start()
        }
    }


    override fun setUserVisibleHint(isVisibleToUser: Boolean) {
        super.setUserVisibleHint(isVisibleToUser)
        mIsVisibleToUser = isVisibleToUser
        if (isVisibleToUser) {
            if (currentPlayer?.isCanPlay == true) {
                if (refreshData) {
                    currentPlayer?.startPlayLogic()
                }
                GSYVideoManager.onResume()
            }
        } else {
            GSYVideoManager.onPause()
        }
    }

    override fun onResume() {
        super.onResume()
        if (mIsVisibleToUser) {
            if (currentPlayer?.isCanPlay == true) {
                if (refreshData) {
                    currentPlayer?.startPlayLogic()
                }
                GSYVideoManager.onResume()
            }
        } else {
            GSYVideoManager.onPause()
        }
    }


    override fun onPause() {
        super.onPause()
        GSYVideoManager.onPause()
    }

    companion object {
        @JvmStatic
        fun newInstance(): MainPagerFragment {
            val args = Bundle()
            val fragment = MainPagerFragment()
            fragment.arguments = args
            return fragment
        }
    }

    override fun showError(throwable: Throwable,isConfigStatus:Boolean) {
        super.showError(throwable,isConfigStatus)
        if (!isNeedLoadData) {
            return
        }
        ll_empty.visibility = View.VISIBLE
        tv_empty_reload.setOnClickListener {
            ll_empty.visibility = View.GONE
            tv_empty_reload.postDelayed({
//                initView()
                lazyLoad()
            }, 500)

        }
    }

    private fun isCanPlay(movieDetailBean: MovieDetailBean?): Boolean {
        if (movieDetailBean?.isCanPlay == Constants.VIDEO_CAN_PLAY) {
            return true
        }
        movieDetailBean?.movieList?.forEach { historyId ->
            if (historyId == movieDetailBean.id) {
                return true
            }
        }
        return false
    }

    override fun initEventAndData() {
        initView()
        EventBus.getDefault().register(this)
    }

    override fun onDataResponse(list: List<MovieBean.RecordsBean>) {
        isNeedLoadData = false
        adapter?.let {
            setLoadMore(it, list, EmptyConfig.NO_TIK_TOK)
        }
        if (refreshData) {
            viewPagerLayoutManager?.scrollToPosition(0)
        }


    }

    override fun onRequestMoveDetail(movieDetailBean: MovieDetailBean?, position: Int) {
        val item = adapter?.getItem(position)
        item?.isCanPlay = isCanPlay(movieDetailBean)
        item?.isRequest = true
        //
        //视频广告的处理
        //图片广告的话，会出现影片不存在的报错
        if (item?.tagId == Constants.AD_MOVIE_ITEM_VIDEO) {
            item.isCanPlay = false
        }
        //是否可以播放本次存储
        // 仅仅判断init的position =0
        if (position == 0) {
            if (item?.isCanPlay == true || item?.isPlayFullUrl == false) {
                currentPlayer?.isCanPlay = true
                currentPlayer?.isClickPlayer = true
                if (mIsVisibleToUser) {
                    currentPlayer?.startPlayLogic()
                }
            } else {
                currentPlayer?.isCanPlay = false
                currentPlayer?.isClickPlayer = false
                adapter?.getViewByPosition(position, R.id.iv_cover)?.let { cover ->
                    cover.setOnClickListener {
                        showRechargeDialog(movieDetailBean?.buyGoldCoin)
                    }
                }
                showRechargeDialog(movieDetailBean?.buyGoldCoin)
            }
        }
        //在这个页面没有动，
        if (reloadData == currentPosition) {
            isCanPlay(item?.isRequest, item, currentPlayer, position)
        }
    }

    @Subscribe(threadMode = ThreadMode.MAIN, sticky = true, priority = 1)
    fun onEventRefreshUser(event: RefreshPageEvent) {
        refreshData = true
        mPage = 1
        lazyLoad()
    }


    private fun showRechargeDialog(coin: Int?) {
        if (coin == 0){
            DialogUtils.payVipDialog(activity as AppCompatActivity,  object : DialogUtils.OnClickListener {
                override fun onLeftClick(view: View?) {
                    presenter?.goShare()

                }

                override fun onRightClick(view: View?) {
                    presenter?.goVip()
                }
            })
        }else{
            DialogUtils.payCoinDialog(activity as AppCompatActivity, coin
                    ?: 0, object : DialogUtils.OnClickListener {
                override fun onLeftClick(view: View?) {
//                    presenter?.goShare()

                }

                override fun onRightClick(view: View?) {
                    presenter?.goWallet()
                }
            })
        }

    }

    override fun onCollectionRefresh(count: Int, position: Int) {
        adapter?.getViewByPosition(position, R.id.tv_like)?.let {
            if (it is TextView) {
                it.text = CommonUtils.setNumberData(count)
            }
        }
    }

    override fun onPlayerMovie() {
        EventBus.getDefault().post(RefreshVisibleEvent(Constants.HISTORY))
    }

    override fun onWinnerRequest(list: List<String>?) {
        initFlipper(list)

    }

    override fun onDestroy() {
        super.onDestroy()
        EventBus.getDefault().unregister(this)
    }

}