package com.hupu.tv.player.app.ui.fragment

import android.content.Context
import android.os.Bundle
import android.text.Spannable
import android.text.SpannableStringBuilder
import android.text.style.ForegroundColorSpan
import android.util.Log
import android.view.View
import androidx.recyclerview.widget.LinearLayoutManager
import com.softgarden.baselibrary.base.BaseActivity
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.app.App
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.base.RefreshFragment
import com.hupu.tv.player.app.base.RefreshVP2Fragment
import com.hupu.tv.player.app.bean.*
import com.hupu.tv.player.app.ui.adapter.MatchAnalysisAdapter
import com.hupu.tv.player.app.ui.adapter.MatchAnalysisDataAdapter
import com.hupu.tv.player.app.ui.contact.MatchAnalysisContact
import com.hupu.tv.player.app.ui.presenter.MatchAnalysisPresenter
import com.hupu.tv.player.app.utils.GlideUtils

import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.utils.RecyclerViewUtil
import kotlinx.android.synthetic.main.fragment_match_analysis.*
import kotlinx.android.synthetic.main.layout_empty.*


/**
 * @author by Dell
 * @date on 2020/6/15
 * @describe
 */
class MatchAnalysisFragment : RefreshVP2Fragment<MatchAnalysisPresenter>(),
    MatchAnalysisContact.Display {
    private var matchId = ""
    private var sportType = 0
    private var homeIntegral: Integral? = null
    private var awayIntegral: Integral? = null
    private var homeTeam: Team? = null
    private var awayTeam: Team? = null
    private var hasHome = true
    private var hasAway = true
    private var hasScore = true
    private var hasList = true
    private var list: ArrayList<MatchRecentDto?>? = arrayListOf()
    private lateinit var adapter: MatchAnalysisAdapter
    private lateinit var awayAdapter: MatchAnalysisAdapter
    private lateinit var analysisDataAdapter: MatchAnalysisDataAdapter
    override val layoutId: Int
        get() = R.layout.fragment_match_analysis

    override val baseActivity: BaseActivity<*>?
        get() = activity as BaseActivity<*>

    override fun onBasketBall(bean: MatchBasketballEntity?) {
        mStatusLayoutManager.showSuccessLayout()
        homeTeam = bean?.teamMatchInfo?.homeTeam
        awayTeam = bean?.teamMatchInfo?.awayTeam
        homeIntegral = bean?.teamIntegralDto?.homeIntegral
        awayIntegral = bean?.teamIntegralDto?.awayIntegral
        list = bean?.matchRecentDtos
        initView()
    }

    override fun onFootball(bean: MatchFootballBeanKt?) {
        mStatusLayoutManager.showSuccessLayout()
        homeTeam = bean?.matchGameInfo?.teamInfo?.homeTeam
        awayTeam = bean?.matchGameInfo?.teamInfo?.awayTeam
        homeIntegral = bean?.teamIntegralDto?.homeIntegral
        awayIntegral = bean?.teamIntegralDto?.awayIntegral
        list = bean?.matchRecentDtos
        initView()
    }

    override val ctx: Context?
        get() = super.ctx

    override fun initEventAndData() {
        initRefreshLayout()
        matchId = arguments?.getString(Constants.MATCH_BEAN_ID, "").orEmpty()
        sportType = arguments?.getInt(Constants.SPORT_TYPE, 0) ?: 0
        initStatusLayout(mRefreshLayout as View)
        mStatusLayoutManager.showLoadingLayout()
    }

    private fun initView() {
        if (awayIntegral == null && homeIntegral == null && list.isNullOrEmpty()) {
            ll_empty.visibility = View.VISIBLE
            nestedScroll.visibility = View.GONE
            return
        } else {
            ll_empty.visibility = View.GONE
            nestedScroll.visibility = View.VISIBLE
        }

        if (awayIntegral == null && homeIntegral == null) {
            ll_score.visibility = View.GONE
            hasScore = false
        } else {
            ll_score.visibility = View.VISIBLE
            initData()
            initRecyclerView()
            iniAdapter()
            initAwayAdapter()
        }

        if (list.isNullOrEmpty()) {
            hasList = false
            ll_analysis.visibility = View.GONE
        } else {
            ll_analysis.visibility = View.VISIBLE
            initAnalysisAdapter()
        }
        if (!hasHome && !hasAway) {
            hasScore = false
            ll_score.visibility = View.GONE
        }

        if (!hasList && !hasScore) {
            ll_empty.visibility = View.VISIBLE
            nestedScroll.visibility = View.GONE
        }
    }

    private fun initAnalysisAdapter() {
        recycler_analysis.layoutManager = LinearLayoutManager(requireContext())
        analysisDataAdapter = MatchAnalysisDataAdapter(
            R.layout.item_analysis_data,
            homeTeam?.teamLogo,
            awayTeam?.teamLogo,
            this
        )
        recycler_analysis.adapter = analysisDataAdapter
        analysisDataAdapter.setNewData(list)
        setAnalysisData()
    }

    private fun setAnalysisData() {
        list?.forEach {
            if (it?.teamRecordName == "历史交锋") {
                val title =
                    "${it.teamRecordName} : ${it.teamRecordWin} ${it.teamRecordTie} ${it.teamRecordLost}"
                val style = SpannableStringBuilder(title)

                style.setSpan(
                    ForegroundColorSpan(requireContext().getColor(R.color.color_FC7436)),
                    calculateOneStart(it),
                    calculateTwoStart(it),
                    Spannable.SPAN_EXCLUSIVE_EXCLUSIVE
                )
                style.setSpan(
                    ForegroundColorSpan(requireContext().getColor(R.color.color_317EB4)),
                    calculateTwoStart(it),
                    calculateThreeStart(it),
                    Spannable.SPAN_EXCLUSIVE_EXCLUSIVE
                )
                style.setSpan(
                    ForegroundColorSpan(requireContext().getColor(R.color.color_46AD23)),
                    calculateThreeStart(it),
                    title.length,
                    Spannable.SPAN_EXCLUSIVE_EXCLUSIVE
                )
                tv_history.text = style
            }
        }
    }

    private fun calculateOneStart(item: MatchRecentDto): Int {
        return item.teamRecordName?.let {
            it.length + 3
        } ?: 0
    }

    private fun calculateTwoStart(item: MatchRecentDto): Int {
        return item.teamRecordWin?.let {
            calculateOneStart(item) + it.length + 1
        } ?: 0
    }

    private fun calculateThreeStart(item: MatchRecentDto): Int {
        return item.teamRecordTie?.let {
            calculateTwoStart(item) + it.length + 1
        } ?: 0

    }

    private fun initData() {
        GlideUtils.loadAvatar(this, homeTeam?.teamLogo, iv_home_logo)
        GlideUtils.loadAvatar(this, awayTeam?.teamLogo, iv_away_logo)
        tv_home_name.text = homeTeam?.teamName
        tv_away_name.text = awayTeam?.teamName
    }


    private fun iniAdapter() {

        mRecyclerView?.layoutManager = LinearLayoutManager(requireContext())
//        mRecyclerView?.let {
//            RecyclerViewUtil.addItemDecoration(requireActivity(), it, R.color.view_color, 1f)
//        }
        adapter = MatchAnalysisAdapter(R.layout.item_match_analysis,sportType)
        mRecyclerView?.adapter = adapter
        if (loadData(homeIntegral)?.size == 0) {
            ll_home.visibility = View.GONE
            hasHome = false
        } else {
            adapter.setNewData(loadData(homeIntegral))
        }

    }

    private fun initAwayAdapter() {
        mRecyclerView_away?.layoutManager = LinearLayoutManager(requireContext())
//        mRecyclerView_away?.let {
//            RecyclerViewUtil.addItemDecoration(requireActivity(), it, R.color.view_color, 1f)
//        }
        awayAdapter = MatchAnalysisAdapter(R.layout.item_match_analysis,sportType)
        mRecyclerView_away?.adapter = awayAdapter
        if (loadData(awayIntegral)?.size == 0) {
            ll_away.visibility = View.GONE
            hasAway = false
        } else {
            awayAdapter.setNewData(loadData(awayIntegral))
        }

    }


    private fun loadData(integral: Integral?): MutableList<MatchAnalysisEntity>? {
        val list = arrayListOf<MatchAnalysisEntity>()
        var hasData = false
        loadBean(integral?.header)?.let {
            list.add(it)
        }

        loadBean(integral?.integralHome)?.let {
            list.add(it)
            hasData = true
        }

        loadBean(integral?.integralAway)?.let {
            list.add(it)
            hasData = true
        }

        loadBean(integral?.integralSum)?.let {
            list.add(it)
            hasData = true
        }
        return if (hasData) {
            list
        } else {
            arrayListOf()
        }


    }

    private fun loadBean(list: List<String>?): MatchAnalysisEntity? {
        if (list != null) {
            if (list.size == 9) {
                return MatchAnalysisEntity(
                    list[0],
                    list[1],
                    list[2],
                    list[3],
                    "",
                    list[4],
                    list[5],
                    list[6],
                    list[7],
                    list[8]
                )
            }
            if (list.size == 10) {
                return MatchAnalysisEntity(
                    list[0],
                    list[1],
                    list[2],
                    list[3],
                    list[4],
                    list[5],
                    list[6],
                    list[7],
                    list[8],
                    list[9]
                )
            }
            if (list.size == 7) {
                return MatchAnalysisEntity(
                    list[0],
                    "",
                    list[1],
                    list[2],
                    list[3],
                    list[4],
                    list[5],
                    "",
                    "",
                    list[6]
                )
            }

        }
        return null
    }


    override fun lazyLoad() {
        if (matchId.isEmpty()) {
            mStatusLayoutManager.showEmptyLayout()
        } else {
            if (sportType == Constants.SPORT_TYPE_FOOTBALL) {
                presenter?.getFootBall(matchId)
            } else {
                presenter?.getBasketBall(matchId)
            }
        }
    }


    companion object {
        @JvmStatic
        fun newInstance(
            id: String, sportType: Int
        ): MatchAnalysisFragment {
            val args = Bundle()
            val fragment = MatchAnalysisFragment()
            args.putString(Constants.MATCH_BEAN_ID, id)
            args.putInt(Constants.SPORT_TYPE, sportType)
            fragment.arguments = args
            return fragment
        }
    }


}