package com.hupu.tv.player.app.ui.fragment

import android.content.Intent
import android.os.Bundle
import android.view.View
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import com.blankj.utilcode.util.TimeUtils

import com.softgarden.baselibrary.utils.ToastUtil
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.base.RefreshVP2Fragment
import com.hupu.tv.player.app.bean.MatchInfoEntity
import com.hupu.tv.player.app.bean.ScheduleEntity
import com.hupu.tv.player.app.event.FollowMatchEvent
import com.hupu.tv.player.app.ui.activity.NewMatchDetailActivity
import com.hupu.tv.player.app.ui.adapter.NewMatchContentAdapter
import com.hupu.tv.player.app.ui.adapter.ScheduleAdapter
import com.hupu.tv.player.app.ui.contact.MatchContentFragmentContract
import com.hupu.tv.player.app.ui.presenter.MatchContentPresenter
import com.hupu.tv.player.app.utils.CommonUtils
import com.softgarden.baselibrary.utils.RecyclerViewUtil
import org.greenrobot.eventbus.EventBus


/**
 * @author by Dell
 * @date on 2020/6/14
 * @describe
 */
class MatchContentFragment : RefreshVP2Fragment<MatchContentPresenter>(),
    MatchContentFragmentContract.Display {
    private lateinit var contentAdapter: NewMatchContentAdapter
    private var sportId: String = ""
    private var sportType: Int = 0
    private var sportName: String = ""
    private var currentPosition = 0
    override val layoutId: Int
        get() = R.layout.fragment_match_content


    override fun initEventAndData() {
        initRecyclerView()
        initRefreshLayout()
        initView()
        initAdapter()
        initStatusLayout(mRefreshLayout as View)
        mStatusLayoutManager.showLoadingLayout()
    }

    public fun requestFollow(id: String, status: Boolean) {
        presenter?.reserveMatch(id, status)
    }


    private fun initView() {
        initStatusLayout(mRecyclerView!!)
        sportId = arguments?.getString(Constants.SPORT_ID).orEmpty()
        sportName = arguments?.getString(Constants.SPORT_NAME).orEmpty()
        sportType = arguments?.getInt(Constants.SPORT_TYPE, 0) ?: 0
        currentPosition = arguments?.getInt(Constants.MATCH_POSITION, 0) ?: 0

    }

    private fun initAdapter() {


        contentAdapter = NewMatchContentAdapter(currentPosition).apply {
            setOnItemClickListener { adapter, view, position ->
                val item = adapter.getItem(position) as MatchInfoEntity
                val intent = Intent(requireContext(), NewMatchDetailActivity::class.java)
                intent.putExtra(Constants.MATCH_BEAN_ID, item.id)
                intent.putExtra(Constants.SPORT_TYPE, item.sportsType)
                startActivity(intent)
            }
        }
        if (currentPosition == 2) {
            val head = View.inflate(requireContext(), R.layout.layout_schedule_head, null)
            contentAdapter.addHeaderView(head)
            head.findViewById<RecyclerView>(R.id.recycler_schedule_head).apply {
                adapter = ScheduleAdapter().apply {
                    setNewData(mutableListOf<ScheduleEntity>()
                        .apply {
                            add(
                                ScheduleEntity(
                                    CommonUtils.getAppointDateMd(0),
                                    CommonUtils.getCalendarWeek(CommonUtils.getAppointDate(0)),
                                    CommonUtils.getAppointDate(0),
                                    true,
                                    true
                                )
                            )
                            add(
                                ScheduleEntity(
                                    CommonUtils.getAppointDateMd(1),
                                    CommonUtils.getCalendarWeek(CommonUtils.getAppointDate(1)),
                                    CommonUtils.getAppointDate(1)
                                )
                            )
                            add(
                                ScheduleEntity(
                                    CommonUtils.getAppointDateMd(2),
                                    CommonUtils.getCalendarWeek(CommonUtils.getAppointDate(2)),
                                    CommonUtils.getAppointDate(2)
                                )
                            )
                            add(
                                ScheduleEntity(
                                    CommonUtils.getAppointDateMd(3),
                                    CommonUtils.getCalendarWeek(CommonUtils.getAppointDate(3)),
                                    CommonUtils.getAppointDate(3)
                                )
                            )
                            add(
                                ScheduleEntity(
                                    CommonUtils.getAppointDateMd(4),
                                    CommonUtils.getCalendarWeek(CommonUtils.getAppointDate(4)),
                                    CommonUtils.getAppointDate(4)
                                )
                            )
                            add(
                                ScheduleEntity(
                                    CommonUtils.getAppointDateMd(5),
                                    CommonUtils.getCalendarWeek(CommonUtils.getAppointDate(5)),
                                    CommonUtils.getAppointDate(5)
                                )
                            )
                            add(
                                ScheduleEntity(
                                    CommonUtils.getAppointDateMd(6),
                                    CommonUtils.getCalendarWeek(CommonUtils.getAppointDate(6)),
                                    CommonUtils.getAppointDate(6)
                                )
                            )

                        })
                    setOnItemClickListener { adapter, view, position ->
                        adapter.data.forEach {
                            it as ScheduleEntity
                            it.isSelected = false
                        }
                        val item = adapter.getItem(position) as ScheduleEntity
                        item.isSelected = true
                        adapter.notifyItemRangeChanged(0,adapter.itemCount)
                        presenter?.getMatchList(sportId,sportType,item.wholeTime,mPage,PAGE_COUNT)
                    }
                }
            }
        }


        mRecyclerView?.apply {
            adapter = contentAdapter
            layoutManager = LinearLayoutManager(activity)
            RecyclerViewUtil.addItemDecoration(requireActivity(), this, R.color.transparent, Constants.item_divider_4 * 2)
        }
    }


    override fun lazyLoad() {
        presenter?.getMatchList(sportId, sportType, "", mPage, PAGE_COUNT)
    }

    companion object {
        fun newInstance(
            sportId: String,
            sportName: String,
            sportType: Int,
            position: Int
        ): MatchContentFragment {
            val args = Bundle()
            val fragment = MatchContentFragment()
            args.putString(Constants.SPORT_ID, sportId)
            args.putInt(Constants.SPORT_TYPE, sportType)
            args.putString(Constants.SPORT_NAME, sportName)
            args.putInt(Constants.MATCH_POSITION, position)
            fragment.arguments = args
            return fragment
        }
    }

    override fun onMatchList(list: List<MatchInfoEntity>?) {
        mStatusLayoutManager.showSuccessLayout()
        setLoadMore(contentAdapter, list)

    }

    override fun showError(throwable: Throwable,isConfigStatus:Boolean) {
        super.showError(throwable,isConfigStatus)
        mStatusLayoutManager.showErrorLayout()
    }


    override fun onSubscribeMatch(id: String, status: Boolean) {
        ToastUtil.s(if (status) "预约成功" else "取消成功")
        contentAdapter.data.forEachIndexed { index, matchInfoEntity ->
            if (matchInfoEntity.id == id) {
                matchInfoEntity.subscribe = status
                contentAdapter.notifyItemChanged(index)
            }
        }
    }


}