package com.hupu.tv.player.app.ui.fragment

import android.content.Intent
import android.os.Bundle
import android.view.View
import androidx.recyclerview.widget.GridLayoutManager

import com.mirkowu.basetoolbar.BaseToolbar

import com.softgarden.baselibrary.utils.RecyclerViewUtil
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.base.RefreshFragment
import com.hupu.tv.player.app.base.RefreshVP2Fragment
import com.hupu.tv.player.app.base.ToolbarFragment

import com.hupu.tv.player.app.bean.LiveBean
import com.hupu.tv.player.app.bean.MatchContentBean
import com.hupu.tv.player.app.bean.MatchDetailBean

import com.hupu.tv.player.app.ui.activity.LiveActivity

import com.hupu.tv.player.app.ui.adapter.MatchDetailLiveAdapter
import com.hupu.tv.player.app.ui.contact.MatchDetailLiveContract

import com.hupu.tv.player.app.ui.presenter.MatchDetailLivePresenter
import com.hupu.tv.player.app.utils.EmptyConfig


/**
 * @author by Dell
 * @date on 2020/6/14
 * @describe
 */
class MatchDetailLiveFragment : RefreshVP2Fragment<MatchDetailLivePresenter>(),
    MatchDetailLiveContract.Display {
    private var liveItemAdapter: MatchDetailLiveAdapter? = null
    private var sportId: String = ""
    override val layoutId: Int
        get() = R.layout.fragment_match_live


    override fun initEventAndData() {
        initRefreshLayout()
        initRecyclerView()
        initView()
        initStatusLayout(mRefreshLayout as View)
        mStatusLayoutManager.showLoadingLayout()
    }

    private fun initView() {
        liveItemAdapter = MatchDetailLiveAdapter()
        mRecyclerView?.adapter = liveItemAdapter
        mRecyclerView?.layoutManager = GridLayoutManager(activity, 2)
        activity?.let {
            RecyclerViewUtil.addGridItemDecoration(
                it,
                mRecyclerView!!,
                R.color.transparent,
                2 * Constants.item_divider
            )
        }
        liveItemAdapter?.setOnItemClickListener { adapter, view, position ->
            val item =
                adapter.getItem(position) as MatchContentBean.MatchListsBean.MatchInfosBean.GuidesBean
            val intent = Intent(activity, LiveActivity::class.java)
            intent.putExtra(Constants.ROOM_ID, item.roomId)
            intent.putExtra(Constants.ROOM_COVER, item.matchCutImg)
            startActivity(intent)
        }

        arguments?.getString(Constants.MATCH_BEAN_ID)?.let {
            sportId = it
        }

    }

    override fun lazyLoad() {
        presenter?.getMatchData(sportId, mPage)
    }

    companion object {
        fun newInstance(id: String): MatchDetailLiveFragment {
            val args = Bundle()
            val fragment = MatchDetailLiveFragment()
            args.putString(Constants.MATCH_BEAN_ID, id)
            fragment.arguments = args
            return fragment
        }
    }


    override fun onMatchDetail(data: MatchDetailBean?) {
        mStatusLayoutManager.showSuccessLayout()
        liveItemAdapter?.let {
            setLoadMore(it, data?.guides, EmptyConfig.NO_DETAIL_LIVE)
        }
    }
}