package com.hupu.tv.player.app.ui.fragment

import android.content.Context
import android.os.Bundle
import android.text.TextUtils
import android.view.View
import androidx.recyclerview.widget.LinearLayoutManager
import com.softgarden.baselibrary.base.BaseActivity
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.base.RefreshFragment
import com.hupu.tv.player.app.base.RefreshVP2Fragment
import com.hupu.tv.player.app.bean.GameStat
import com.hupu.tv.player.app.bean.MatchDataGoalEntity
import com.hupu.tv.player.app.bean.MatchGoals
import com.hupu.tv.player.app.ui.adapter.MatchDataAdapter
import com.hupu.tv.player.app.ui.adapter.MatchTechAdapter

import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import kotlinx.android.synthetic.main.fragment_match_data.*
import kotlinx.android.synthetic.main.layout_empty.*


/**
 * @author by Dell
 * @date on 2020/6/15
 * @describe
 */
class MatchFootDataFragment : RefreshVP2Fragment<IBasePresenter>(), IBaseDisplay {
    private var roomid = ""
    private lateinit var adapter: MatchDataAdapter
    private lateinit var techAdapter: MatchTechAdapter
    private var gameList: ArrayList<GameStat?>? = null
    private var goalList: ArrayList<MatchGoals?>? = null
    override val layoutId: Int
        get() = R.layout.fragment_match_data

    override val baseActivity: BaseActivity<*>?
        get() = activity as BaseActivity<*>


    override val ctx: Context?
        get() = super.ctx

    override fun initEventAndData() {

        arguments?.let {
            roomid = it.getString(Constants.ROOM_ID, "")
            gameList = it.getSerializable(Constants.MATCH_DATA_GAME) as? ArrayList<GameStat?>?
            goalList = it.getSerializable(Constants.MATCH_DATA_GOAL) as? ArrayList<MatchGoals?>?
        }
        if (gameList.isNullOrEmpty() && goalList.isNullOrEmpty()) {
            ll_empty.visibility = View.VISIBLE
            nestedScroll.visibility = View.GONE
        } else {
            ll_empty.visibility = View.GONE
            nestedScroll.visibility = View.VISIBLE
        }
        initRefreshLayout()
        initRecyclerView()
        initAdapter()
        initTechRecyclerView()
    }


    private fun initAdapter() {
        mRecyclerView?.layoutManager = LinearLayoutManager(requireActivity())
        adapter = MatchDataAdapter(R.layout.item_match_data)
        mRecyclerView?.adapter = adapter
        adapter.setNewData(loadData())
    }

    private fun initTechRecyclerView() {
        recycler_tech?.layoutManager = LinearLayoutManager(requireActivity())
        techAdapter = MatchTechAdapter(R.layout.item_match_foot_tech)
        recycler_tech?.adapter = techAdapter
        techAdapter.setNewData(gameList)
    }

    private fun loadData(): MutableList<MatchDataGoalEntity?>? {
        val list = arrayListOf<MatchDataGoalEntity?>()
        goalList?.forEach {
            list.add(MatchDataGoalEntity(it?.type, it?.minute, it?.eventName, it?.score, it?.pname))
            list.add(MatchDataGoalEntity(it?.type, it?.minute, it?.eventName, it?.score, it?.eventName))
        }
        return list
    }


    override fun lazyLoad() {
//        presenter?.getRoomInfo(roomid)
//        presenter?.getBaseketballInfo(roomid)
        mRecyclerView?.postDelayed({
            finishRefresh()
        }, 3000)
    }


    companion object {
        @JvmStatic
        fun newInstance(id: String, gameList: List<GameStat?>?, matchGoals: List<MatchGoals?>?): MatchFootDataFragment {
            val args = Bundle()
            val fragment = MatchFootDataFragment()
            args.putString(Constants.ROOM_ID, id)
            args.putSerializable(Constants.MATCH_DATA_GAME, gameList as? ArrayList)
            args.putSerializable(Constants.MATCH_DATA_GOAL, matchGoals as? ArrayList)
            fragment.arguments = args
            return fragment
        }
    }


}