package com.hupu.tv.player.app.ui.fragment

import android.content.Context
import android.os.Bundle
import android.view.View
import androidx.recyclerview.widget.LinearLayoutManager
import com.softgarden.baselibrary.base.BaseActivity
import com.softgarden.baselibrary.utils.RecyclerViewUtil
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.base.RefreshFragment
import com.hupu.tv.player.app.bean.TextLiveBean
import com.hupu.tv.player.app.bean.TextLiveData
import com.hupu.tv.player.app.ui.adapter.TextLiveAdapter
import com.hupu.tv.player.app.ui.contact.MatchFootLiveFragmentContact
import com.hupu.tv.player.app.ui.presenter.MatchFootLiverFragmentPresenter
import kotlinx.android.synthetic.main.fragment_match_player.*


/**
 * @author by Dell
 * @date on 2020/6/15
 * @describe
 */
class MatchFootLiveFragment : RefreshFragment<MatchFootLiverFragmentPresenter>(), MatchFootLiveFragmentContact.Display {
    private var roomid = ""
    private lateinit var adapter: TextLiveAdapter
    override val layoutId: Int
        get() = R.layout.fragment_text_live

    override val baseActivity: BaseActivity<*>?
        get() = activity as BaseActivity<*>

    override fun onLive(data: List<TextLiveData>?) {
        setLoadMore(adapter, data)
    }


    override val ctx: Context?
        get() = super.ctx

    override fun initEventAndData() {
        arguments?.let {
            roomid = it.getString(Constants.ROOM_ID, "")
        }
        initRefreshLayout()
        initRecyclerView()
        initAdapter()
    }

    private fun initAdapter() {
        mRecyclerView?.layoutManager =LinearLayoutManager(requireActivity())
        adapter = TextLiveAdapter(R.layout.item_text_live)
        mRecyclerView?.adapter = adapter
    }


    override fun lazyLoad() {
        presenter?.getLiveData(roomid, mPage)
    }


    companion object {

        @JvmStatic
        fun newInstance(id: String): MatchFootLiveFragment {
            val args = Bundle()
            val fragment = MatchFootLiveFragment()
            args.putString(Constants.ROOM_ID, id)
            fragment.arguments = args
            return fragment
        }
    }


}