package com.hupu.tv.player.app.ui.fragment

import android.os.Bundle

import android.view.View
import androidx.appcompat.app.AppCompatActivity
import androidx.fragment.app.Fragment
import androidx.viewpager.widget.ViewPager
import androidx.viewpager2.widget.ViewPager2
import com.flyco.tablayout.utils.FragmentBasePager2Adapter
import com.kongzue.dialog.v3.WaitDialog
import com.mirkowu.basetoolbar.BaseToolbar
import com.softgarden.baselibrary.base.FragmentBaseStatePagerAdapter
import com.softgarden.baselibrary.utils.SPUtil
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.base.RefreshFragment
import com.hupu.tv.player.app.base.RefreshVP2Fragment
import com.hupu.tv.player.app.base.ToolbarFragment
import com.hupu.tv.player.app.bean.TitleSortBean
import com.hupu.tv.player.app.event.RefreshUserEvent
import com.hupu.tv.player.app.event.SubscribeEvent

import com.hupu.tv.player.app.event.VisibleEvent
import com.hupu.tv.player.app.ui.contact.MatchFragmentContact
import com.hupu.tv.player.app.ui.presenter.MatchFragmentPresenter
import com.hupu.tv.player.app.utils.DialogUtils
import com.mirkowu.statusbarutil.StatusBarUtil
import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import kotlinx.android.synthetic.main.fragment_match_main.*

import kotlinx.android.synthetic.main.layout_empty_no_data.*
import me.jessyan.autosize.utils.LogUtils
import org.greenrobot.eventbus.EventBus
import org.greenrobot.eventbus.Subscribe
import org.greenrobot.eventbus.ThreadMode


/**
 * @author by Dell
 * @date on 2020/6/15
 * @describe
 */
class MatchFragment : RefreshFragment<IBasePresenter>(), IBaseDisplay {
    val mFragments = ArrayList<Fragment>()
    private var currentFragment = 0
    override val layoutId: Int
        get() = R.layout.fragment_match_main




    override fun lazyLoad() {
        mStatusLayoutManager.showSuccessLayout()
        initViewPager(defaultList())
    }

    private fun defaultList(): MutableList<TitleSortBean> {
        return mutableListOf<TitleSortBean>().apply {
            add(TitleSortBean().apply {
                sportsName = Constants.MATCH_FOOTBALL_TEXT
                sportsId = Constants.SPORT_TYPE_FOOTBALL.toString()
            })

            add(TitleSortBean().apply {
                sportsName = Constants.MATCH_BASKETBALL_TEXT
                sportsId = Constants.SPORT_TYPE_BASKETBALL.toString()
            })

        }
    }

    private fun initViewPager(list: List<TitleSortBean>) {
        mFragments.clear()
        val mTitles = arrayOfNulls<String>(list.size)
        list.forEachIndexed { index, titleSortBean ->
            mTitles[index] = titleSortBean.sportsName
            mFragments.add(
                MatchTypeFragment.newInstance(
                    titleSortBean.sportsId
                )
            )
        }

        val mAdapter =
            FragmentBasePager2Adapter(childFragmentManager, mFragments, mTitles, lifecycle)
        vp_match.offscreenPageLimit = list.size
        vp_match.adapter = mAdapter
        tabLayout_main.setViewPager2(vp_match)
        vp_match.registerOnPageChangeCallback(object : ViewPager2.OnPageChangeCallback() {
            override fun onPageSelected(position: Int) {
                currentFragment = position
            }
        })
    }

    companion object {
        @JvmStatic
        fun newInstance(): MatchFragment {
            val args = Bundle()
            val fragment = MatchFragment()
            fragment.arguments = args
            return fragment
        }
    }

    @Subscribe(threadMode = ThreadMode.MAIN, sticky = true, priority = 1)
    fun onEventRefresh(event: SubscribeEvent) {
        if (event.className == Constants.SUBSCRIBE_MATCH) {
            if (SPUtil[Constants.USER_LOGIN, false] == true) {
                (mFragments[currentFragment] as MatchTypeFragment).subScribeMatch(
                    event.parentPosition,
                    event.id,
                    event.isStatus
                )
            } else {
                DialogUtils.showLogin(requireActivity() as AppCompatActivity)
            }
        }
    }

    override fun initEventAndData() {
        EventBus.getDefault().register(this)
        initStatusLayout(ll_root)
        mStatusLayoutManager.showLoadingLayout()


    }

    override fun onDestroy() {
        super.onDestroy()
        EventBus.getDefault().unregister(this)
    }

}