package com.hupu.tv.player.app.ui.fragment

import android.graphics.Typeface
import android.os.Bundle
import android.view.View
import androidx.fragment.app.Fragment
import com.flyco.tablayout.utils.FragmentBasePager2Adapter

import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.base.RefreshVP2Fragment
import com.hupu.tv.player.app.bean.MatchIndexDataEntity
import com.hupu.tv.player.app.bean.MatchOddBasketEntity
import com.hupu.tv.player.app.bean.MatchOddEntity
import com.hupu.tv.player.app.ui.contact.MatchIndexContact
import com.hupu.tv.player.app.ui.presenter.MatchIndexPresenter
import com.softgarden.baselibrary.base.FragmentBasePagerAdapter
import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import kotlinx.android.synthetic.main.custom_row_sent_message.*

import kotlinx.android.synthetic.main.fragment_detail_index.*


/**
 * @author by Dell
 * @date on 2020/6/14
 * @describe
 */

class MatchIndexFragment : RefreshVP2Fragment<MatchIndexPresenter>(), MatchIndexContact.Display {
    private val rangFenList = arrayListOf<MatchIndexDataEntity>()
    private val ouzhiList = arrayListOf<MatchIndexDataEntity>()
    private val bigSmallList = arrayListOf<MatchIndexDataEntity>()
    private var sportId: String = ""
    private var type = 1;
    override val layoutId: Int
        get() = R.layout.fragment_detail_index


    override fun initEventAndData() {
        initRefreshLayout()
        initView()
        initStatusLayout(mRefreshLayout as View)
        mStatusLayoutManager.showLoadingLayout()
    }

    private fun initView() {
        arguments?.getString(Constants.MATCH_BEAN_ID)?.let {
            sportId = it
        }
        arguments?.getInt(Constants.INDEX_MATCH_TYPE)?.let {
            type = it
        }
        initData()

    }

    private fun initViewPager() {
        val mFragment = ArrayList<Fragment>()
        mFragment.add(MatchIndexItemFragment.newInstance(rangFenList, 1))
        mFragment.add(MatchIndexItemFragment.newInstance(ouzhiList, 2))
        mFragment.add(MatchIndexItemFragment.newInstance(bigSmallList, 3))
        val fragmentBasePagerAdapter = FragmentBasePager2Adapter(childFragmentManager, mFragment, arrayOf(),lifecycle)
        vp_index.adapter = fragmentBasePagerAdapter
        vp_index.offscreenPageLimit = mFragment.size
        vp_index.currentItem = 0

    }

    private fun initData() {
        setDefaultSelected()
        tv_handicap.isSelected = true
        tv_handicap.setTypeface(Typeface.DEFAULT, Typeface.BOLD)

        tv_handicap.setOnClickListener {
            setDefaultSelected()
            tv_handicap.isSelected = true
            tv_handicap.setTypeface(Typeface.DEFAULT, Typeface.BOLD)
            vp_index.currentItem = 0
        }

        tv_indemnity.setOnClickListener {
            setDefaultSelected()
            tv_indemnity.isSelected = true
            tv_indemnity.setTypeface(Typeface.DEFAULT, Typeface.BOLD)
            vp_index.currentItem = 1
        }

        tv_total.setOnClickListener {
            setDefaultSelected()
            tv_total.isSelected = true
            tv_total.setTypeface(Typeface.DEFAULT, Typeface.BOLD)
            vp_index.currentItem = 2
        }
    }

    private fun setDefaultSelected() {
        tv_handicap.isSelected = false
        tv_indemnity.isSelected = false
        tv_total.isSelected = false
        tv_handicap.setTypeface(Typeface.DEFAULT, Typeface.NORMAL)
        tv_indemnity.setTypeface(Typeface.DEFAULT, Typeface.NORMAL)
        tv_total.setTypeface(Typeface.DEFAULT, Typeface.NORMAL)
    }

    override fun lazyLoad() {
        if (sportId.isEmpty()) {
            mStatusLayoutManager.showEmptyLayout()
        } else {
            if (type == Constants.SPORT_TYPE_FOOTBALL) {
                presenter?.getFootBallOdds(sportId)
            } else {
                presenter?.getBasketBallOdds(sportId)
            }

        }
    }

    companion object {
        fun newInstance(id: String, type: Int): MatchIndexFragment {
            val args = Bundle()
            val fragment = MatchIndexFragment()
            args.putString(Constants.MATCH_BEAN_ID, id)
            args.putInt(Constants.INDEX_MATCH_TYPE, type)
            fragment.arguments = args
            return fragment
        }
    }


    override fun onOdds(data: MatchOddEntity?) {
        mStatusLayoutManager.showSuccessLayout()
        data?.let {
            it.yazhis?.forEach { yazhi ->
                val rangfen = MatchIndexDataEntity()
                rangfen.company = yazhi?.companyName.orEmpty()
                rangfen.first = (yazhi?.yaZhi?.initialOdds?.home ?: 0.0).toString()
                rangfen.second = (yazhi?.yaZhi?.initialOdds?.handicap ?: 0.0).toString()
                rangfen.third = (yazhi?.yaZhi?.initialOdds?.away ?: 0.0).toString()
                rangfen.fourth = (yazhi?.yaZhi?.nowOdds?.home ?: 0.0).toString()
                rangfen.fifth = (yazhi?.yaZhi?.nowOdds?.handicap ?: 0.0).toString()
                rangfen.sixth = (yazhi?.yaZhi?.nowOdds?.away ?: 0.0).toString()
                rangFenList.add(rangfen)
            }
            it.ouzhis?.forEach { ouzhi ->
                val oupei = MatchIndexDataEntity()
                oupei.type = ouzhi?.ouZhi?.initialOdds?.type
                oupei.company = ouzhi?.companyName.orEmpty()
                oupei.first = (ouzhi?.ouZhi?.initialOdds?.win ?: 0.0).toString()
                oupei.second = (ouzhi?.ouZhi?.initialOdds?.draw ?: 0.0).toString()
                oupei.third = (ouzhi?.ouZhi?.initialOdds?.loss ?: 0.0).toString()
                oupei.fourth = (ouzhi?.ouZhi?.initialOdds?.homeWinRate ?: 0.0).toString()
                oupei.fifth = (ouzhi?.ouZhi?.initialOdds?.awayWinRate ?: 0.0).toString()
                oupei.sixth = (ouzhi?.ouZhi?.initialOdds?.breakRate ?: 0.0).toString()
                oupei.typeSecond = ouzhi?.ouZhi?.nowOdds?.type
                oupei.firstSecond = (ouzhi?.ouZhi?.nowOdds?.win ?: 0.0).toString()
                oupei.secondSecond = (ouzhi?.ouZhi?.nowOdds?.draw ?: 0.0).toString()
                oupei.thirdSecond = (ouzhi?.ouZhi?.nowOdds?.loss ?: 0.0).toString()
                oupei.fourthSecond = (ouzhi?.ouZhi?.nowOdds?.homeWinRate ?: 0.0).toString()
                oupei.fifthSecond = (ouzhi?.ouZhi?.nowOdds?.awayWinRate ?: 0.0).toString()
                oupei.sixthSecond = (ouzhi?.ouZhi?.nowOdds?.breakRate ?: 0.0).toString()

                ouzhiList.add(oupei)
            }

            it.daxiaos?.forEach { daxiao ->
                val smallBig = MatchIndexDataEntity()
                smallBig.company = daxiao?.companyName.orEmpty()
                smallBig.first = (daxiao?.daXiao?.initialOdds?.over ?: 0.0).toString()
                smallBig.second = (daxiao?.daXiao?.initialOdds?.handicap ?: 0.0).toString()
                smallBig.third = (daxiao?.daXiao?.initialOdds?.under ?: 0.0).toString()
                smallBig.fourth = (daxiao?.daXiao?.nowOdds?.over ?: 0.0).toString()
                smallBig.fifth = (daxiao?.daXiao?.nowOdds?.handicap ?: 0.0).toString()
                smallBig.sixth = (daxiao?.daXiao?.nowOdds?.under ?: 0.0).toString()
                bigSmallList.add(smallBig)
            }


            initViewPager()
        }
    }

    override fun onBasketOdds(data: MatchOddBasketEntity?) {
        mStatusLayoutManager.showSuccessLayout()
        data?.let {
            it.ranFens?.forEach { yazhi ->
                val rangfen = MatchIndexDataEntity()
                rangfen.company = yazhi?.companyName.orEmpty()
                rangfen.first = (yazhi?.ranFen?.initialOdds?.home ?: 0.0).toString()
                rangfen.second = (yazhi?.ranFen?.initialOdds?.handicap ?: 0.0).toString()
                rangfen.third = (yazhi?.ranFen?.initialOdds?.away ?: 0.0).toString()
                rangfen.fourth = (yazhi?.ranFen?.nowOdds?.home ?: 0.0).toString()
                rangfen.fifth = (yazhi?.ranFen?.nowOdds?.handicap ?: 0.0).toString()
                rangfen.sixth = (yazhi?.ranFen?.nowOdds?.away ?: 0.0).toString()
                rangFenList.add(rangfen)
            }
            it.ouZhis?.forEach { ouzhi ->
                val oupei = MatchIndexDataEntity()
                oupei.type = ouzhi?.ouZhi?.initialOdds?.type
                oupei.company = ouzhi?.companyName.orEmpty()
                oupei.first = (ouzhi?.ouZhi?.initialOdds?.win ?: 0.0).toString()
                oupei.second = (ouzhi?.ouZhi?.initialOdds?.draw ?: 0.0).toString()
                oupei.third = (ouzhi?.ouZhi?.initialOdds?.loss ?: 0.0).toString()
                oupei.fourth = (ouzhi?.ouZhi?.initialOdds?.homeWinRate ?: 0.0).toString()
                oupei.fifth = (ouzhi?.ouZhi?.initialOdds?.awayWinRate ?: 0.0).toString()
                oupei.sixth = (ouzhi?.ouZhi?.initialOdds?.breakRate ?: 0.0).toString()
                oupei.typeSecond = ouzhi?.ouZhi?.nowOdds?.type
                oupei.firstSecond = (ouzhi?.ouZhi?.nowOdds?.win ?: 0.0).toString()
                oupei.secondSecond = (ouzhi?.ouZhi?.nowOdds?.draw ?: 0.0).toString()
                oupei.thirdSecond = (ouzhi?.ouZhi?.nowOdds?.loss ?: 0.0).toString()
                oupei.fourthSecond = (ouzhi?.ouZhi?.nowOdds?.homeWinRate ?: 0.0).toString()
                oupei.fifthSecond = (ouzhi?.ouZhi?.nowOdds?.awayWinRate ?: 0.0).toString()
                oupei.sixthSecond = (ouzhi?.ouZhi?.nowOdds?.breakRate ?: 0.0).toString()

                ouzhiList.add(oupei)
            }

            it.daXiaos?.forEach { daxiao ->
                val smallBig = MatchIndexDataEntity()
                smallBig.company = daxiao?.companyName.orEmpty()
                smallBig.first = (daxiao?.daXiao?.initialOdds?.over ?: 0.0).toString()
                smallBig.second = (daxiao?.daXiao?.initialOdds?.handicap ?: 0.0).toString()
                smallBig.third = (daxiao?.daXiao?.initialOdds?.under ?: 0.0).toString()
                smallBig.fourth = (daxiao?.daXiao?.nowOdds?.over ?: 0.0).toString()
                smallBig.fifth = (daxiao?.daXiao?.nowOdds?.handicap ?: 0.0).toString()
                smallBig.sixth = (daxiao?.daXiao?.nowOdds?.under ?: 0.0).toString()
                bigSmallList.add(smallBig)
            }
            initViewPager()
        }
    }
}