package com.hupu.tv.player.app.ui.fragment

import android.os.Bundle
import android.view.View
import androidx.recyclerview.widget.LinearLayoutManager

import com.mirkowu.basetoolbar.BaseToolbar

import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.base.RefreshFragment
import com.hupu.tv.player.app.base.RefreshVP2Fragment
import com.hupu.tv.player.app.base.ToolbarFragment
import com.hupu.tv.player.app.bean.MatchIndexDataEntity
import com.hupu.tv.player.app.ui.adapter.MatchIndexAdapter

import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import kotlinx.android.synthetic.main.fragment_detail_item_index.*


/**
 * @author by Dell
 * @date on 2020/6/14
 * @describe
 */
class MatchIndexItemFragment : RefreshVP2Fragment<IBasePresenter>(), IBaseDisplay {
    private var list: ArrayList<MatchIndexDataEntity>? = null
    private var type = 1
    private lateinit var adapter: MatchIndexAdapter

    override val layoutId: Int
        get() = R.layout.fragment_detail_item_index

    override fun initEventAndData() {
        list = arguments?.getSerializable(Constants.INDEX_DATA) as? ArrayList<MatchIndexDataEntity>?
        type = arguments?.getInt(Constants.INDEX_TYPE) ?: 1
        initRecyclerView()
        initAdapter()
//        initStatusLayout(ll_root as View)

    }

    private fun initAdapter() {
        mRecyclerView?.layoutManager = LinearLayoutManager(requireContext())
        adapter = MatchIndexAdapter(type)
        val layoutId = when (type) {
            1 -> R.layout.item_match_index_normal
            2 -> R.layout.item_match_index_normal_oupei
            3 -> R.layout.item_match_index_big_small_ball
            else -> 0
        }
        adapter.addHeaderView(View.inflate(requireContext(), layoutId, null))
        mRecyclerView?.adapter = adapter
        adapter.setNewData(list)

    }

    override fun lazyLoad() {

    }

    companion object {
        fun newInstance(data: ArrayList<MatchIndexDataEntity>, type: Int): MatchIndexItemFragment {
            val args = Bundle()
            val fragment = MatchIndexItemFragment()
            args.putSerializable(Constants.INDEX_DATA, data)
            args.putInt(Constants.INDEX_TYPE, type)
            fragment.arguments = args
            return fragment
        }
    }


}