package com.hupu.tv.player.app.ui.fragment

import android.content.Intent
import android.os.Bundle
import android.view.View
import androidx.recyclerview.widget.LinearLayoutManager

import com.mirkowu.basetoolbar.BaseToolbar

import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.base.RefreshVP2Fragment
import com.hupu.tv.player.app.base.ToolbarFragment
import com.hupu.tv.player.app.bean.NewsDataBean
import com.hupu.tv.player.app.bean.NewsListEntity
import com.hupu.tv.player.app.ui.activity.NewsDetailActivity
import com.hupu.tv.player.app.ui.adapter.NewsListAdapter
import com.hupu.tv.player.app.ui.contact.MatchNewsContract
import com.hupu.tv.player.app.ui.presenter.MatchNewsPresenter

import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.utils.RecyclerViewUtil


/**
 * @author by Dell
 * @date on 2020/6/14
 * @describe
 */
class MatchNewsFragment : RefreshVP2Fragment<MatchNewsPresenter>(), MatchNewsContract.Display {
    private var sportId: String = ""
    private lateinit var adapter: NewsListAdapter
    override val layoutId: Int
        get() = R.layout.fragment_news_match

    override fun initEventAndData() {
        initRefreshLayout()
        initView()
        initRecyclerView()
        initAdapter()
        initStatusLayout(mRefreshLayout as View)
        mStatusLayoutManager.showLoadingLayout()
    }

    private fun initAdapter() {
        adapter = NewsListAdapter()
        mRecyclerView?.layoutManager = LinearLayoutManager(requireContext())
        activity?.let { RecyclerViewUtil.addItemDecoration(it, mRecyclerView!!, R.color.view_color, 1) }
        mRecyclerView?.adapter = adapter
        adapter.setOnItemClickListener { adapter, view, position ->
            val intent = Intent(requireActivity(), NewsDetailActivity::class.java)
            val bean = adapter.getItem(position) as? NewsListEntity
            intent.putExtra(Constants.NEWS_DETAIL,bean?.id?.toString())
            startActivity(intent)
        }
    }

    private fun initView() {

        arguments?.getString(Constants.MATCH_BEAN_ID)?.let {
            sportId = it
        }

    }

    override fun lazyLoad() {
        presenter?.getNewsList(sportId,mPage)
    }

    companion object {
        fun newInstance(id: String): MatchNewsFragment {
            val args = Bundle()
            val fragment = MatchNewsFragment()
            args.putString(Constants.MATCH_BEAN_ID, id)
            fragment.arguments = args
            return fragment
        }
    }

    override fun onNewsData(data: NewsDataBean?) {
        mStatusLayoutManager.showSuccessLayout()
        setLoadMore(adapter,data?.dataList)
    }
}