package com.hupu.tv.player.app.ui.fragment

import android.os.Bundle

import androidx.appcompat.app.AppCompatActivity
import androidx.fragment.app.Fragment
import androidx.viewpager2.widget.ViewPager2
import com.flyco.tablayout.utils.FragmentBasePager2Adapter
import com.softgarden.baselibrary.utils.SPUtil
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.base.RefreshVP2Fragment
import com.hupu.tv.player.app.bean.TitleSortBean
import com.hupu.tv.player.app.event.SubscribeEvent
import com.hupu.tv.player.app.utils.DialogUtils
import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import kotlinx.android.synthetic.main.fragment_match_main.*

import me.jessyan.autosize.utils.LogUtils
import org.greenrobot.eventbus.EventBus
import org.greenrobot.eventbus.Subscribe
import org.greenrobot.eventbus.ThreadMode


/**
 * @author by Dell
 * @date on 2020/6/15
 * @describe
 */
class MatchTypeFragment : RefreshVP2Fragment<IBasePresenter>(), IBaseDisplay {

    private var mFragments = ArrayList<Fragment>()
    private var currentFragment = 0
    private var mSportId = ""
    override val layoutId: Int
        get() = R.layout.fragment_match_type



    override fun lazyLoad() {
        initViewPager(defaultList())
    }

    fun subScribeMatch(position:Int,id:String,status:Boolean){
        (mFragments[position] as MatchContentFragment).requestFollow(id, status)
    }

    private fun initViewPager(list: List<TitleSortBean>) {
        val mTitles = arrayOfNulls<String>(list.size)
        list.forEachIndexed { index, titleSortBean ->
            mTitles[index] = titleSortBean.sportsName
            mFragments.add(
                MatchContentFragment.newInstance(
                    titleSortBean.sportsId,
                    titleSortBean.sportsName,
                    titleSortBean.sportType,
                    titleSortBean.position
                )
            )
        }

        val mAdapter =
            FragmentBasePager2Adapter(childFragmentManager, mFragments, mTitles, lifecycle)
        vp_match.offscreenPageLimit = list.size
        vp_match.adapter = mAdapter
        tabLayout_main.setViewPager2(vp_match)
//        tabLayout_main.setViewPager2ForIcon(vp_match, arrayListOf<Int>().apply {
//            add(R.mipmap.icon_match_all_match)
//            add(R.mipmap.icon_match_start)
//            add(R.mipmap.icon_match_schedule)
//            add(R.mipmap.icon_match_result)
//        })
        vp_match.registerOnPageChangeCallback(object : ViewPager2.OnPageChangeCallback() {
            override fun onPageSelected(position: Int) {
                currentFragment = position
            }
        })
    }


    @Subscribe(threadMode = ThreadMode.MAIN, sticky = true, priority = 1)
    fun onEventContent(event: SubscribeEvent) {
        if (event.className != "match") {
            return
        }
        LogUtils.e("event")
        if (SPUtil[Constants.USER_LOGIN, false] == true) {
            val matchContentFragment = mFragments[currentFragment] as MatchContentFragment
            matchContentFragment.requestFollow(event.id, event.isStatus)
        } else {
            DialogUtils.showLogin(activity as AppCompatActivity)
        }
    }

    companion object {
        @JvmStatic
        fun newInstance(sportId: String): MatchTypeFragment {
            val args = Bundle()
            val fragment = MatchTypeFragment()
            args.putString(Constants.SPORT_ID, sportId)
            fragment.arguments = args
            return fragment
        }
    }

    override fun initEventAndData() {
        mSportId = arguments?.getString(Constants.SPORT_ID, "").orEmpty()
        EventBus.getDefault().register(this)
    }

    override fun onDestroy() {
        super.onDestroy()
        EventBus.getDefault().unregister(this)
    }

    private fun defaultList(): MutableList<TitleSortBean> {
        return mutableListOf<TitleSortBean>().apply {
            add(TitleSortBean().apply {
                sportsName = Constants.MATCH_TITLE_ALL
                sportType = Constants.MATCH_TITLE_ALL_ID
                sportsId = mSportId
                position = 0
            })
            add(TitleSortBean().apply {
                sportsName = Constants.MATCH_TITLE_START
                sportType = Constants.MATCH_TITLE_START_ID
                sportsId = mSportId
                position = 1
            })
            add(TitleSortBean().apply {
                sportsName = Constants.MATCH_TITLE_SCHEDULE
                sportType = Constants.MATCH_TITLE_SCHEDULE_ID
                sportsId = mSportId
                position = 2
            })
            add(TitleSortBean().apply {
                sportsName = Constants.MATCH_TITLE_RESULT
                sportType = Constants.MATCH_TITLE_RESULT_ID
                sportsId = mSportId
                position = 3
            })


        }
    }


}