package com.hupu.tv.player.app.ui.fragment

import android.content.Context
import android.os.Bundle
import android.view.View

import androidx.appcompat.app.AppCompatActivity
import cc.taylorzhang.singleclick.onSingleClick
import com.softgarden.baselibrary.base.BaseActivity
import com.softgarden.baselibrary.utils.SPUtil
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.base.RefreshFragment
import com.hupu.tv.player.app.bean.*
import com.hupu.tv.player.app.event.RefreshUserEvent
import com.hupu.tv.player.app.event.RequestRefreshUserEvent
import com.hupu.tv.player.app.ui.activity.*
import com.hupu.tv.player.app.ui.contact.MineNewFragmentContact
import com.hupu.tv.player.app.ui.presenter.NewMineFragmentPresenter
import com.hupu.tv.player.app.utils.DialogUtils
import com.hupu.tv.player.app.utils.GlideUtils
import com.hupu.tv.player.app.utils.ViewExtra.toDecimal
import kotlinx.android.synthetic.main.fragment_mine_main_new.*
import org.greenrobot.eventbus.EventBus
import org.greenrobot.eventbus.Subscribe
import org.greenrobot.eventbus.ThreadMode


/**
 * @author by Dell
 * @date on 2020/6/15
 * @describe
 */
class NewMineFragment : RefreshFragment<NewMineFragmentPresenter>(),
    MineNewFragmentContact.IDisplay {
    override val layoutId: Int
        get() = R.layout.fragment_mine_main_new

    override val baseActivity: BaseActivity<*>?
        get() = activity as BaseActivity<*>


    override val ctx: Context?
        get() = super.ctx

    override fun initEventAndData() {
        EventBus.getDefault().register(this)
        initListener()
        initRefreshLayout()
        initStatusLayout(mRefreshLayout as View)
        mStatusLayoutManager.showLoadingLayout()
    }

    private fun initListener() {
        ll_user_info.onSingleClick {
            startActivity(UserInfoActivity::class.java)
        }
        ll_coin.onSingleClick {
            startActivity(UserCoinActivity::class.java)
        }

        ll_level.onSingleClick {
            startActivity(UserLevelActivity::class.java)
        }
        ll_report.onSingleClick {
            startActivity(ReportActivity::class.java)
        }

        ll_follow.onSingleClick{
            startActivity(FollowActivity::class.java)
        }
        ll_subscribe.onSingleClick{
            startActivity(SubscribeActivity::class.java)
        }

        ll_message.onSingleClick {
            startActivity(MessageActivity::class.java)
        }

        iv_setting.onSingleClick {
            startActivity(SettingActivity::class.java)
        }

        ll_account_bind.onSingleClick {
            startActivity(AccountSettingActivity::class.java)
        }
        ll_about.onSingleClick {
            startActivity(AboutActivity::class.java)
        }
    }


    override fun onRefresh() {
        presenter?.refreshUserData()
    }

    override fun lazyLoad() {
        presenter?.refreshUserData()
    }

    @Subscribe(threadMode = ThreadMode.MAIN, sticky = true, priority = 1)
    fun onEventRefreshUser(event: RefreshUserEvent) {
        setViewData()
    }


    @Subscribe(threadMode = ThreadMode.MAIN, sticky = true, priority = 1)
    fun onEventGetUserRefresh(event: RequestRefreshUserEvent) {
        presenter?.refreshUserData()
    }

    private fun setViewData() {
        val liveUserBean = SPUtil.getSerializableObject<LiveUserBean>(Constants.LIVE_USER_BEAN)
        liveUserBean?.let {
            tv_user_nick_name.text = it.userName ?: ""
            GlideUtils.loadAvatar(this, it.avatarUrl, iv_user_head)
            tv_level.text = "LV.${it.level}"
            tv_coin.text = it.gold.toDecimal()
        }
    }


    override fun onRefreshUserData() {
        mStatusLayoutManager.showSuccessLayout()
        setViewData()
    }


    override fun onDestroy() {
        super.onDestroy()
        EventBus.getDefault().unregister(this)
    }

    companion object {
        @JvmStatic
        fun newInstance(): NewMineFragment {
            val args = Bundle()
            val fragment = NewMineFragment()
            fragment.arguments = args
            return fragment
        }
    }
}