package com.hupu.tv.player.app.ui.fragment

import android.content.Context
import android.content.Intent
import android.os.Bundle
import android.view.View
import androidx.recyclerview.widget.LinearLayoutManager

import com.mirkowu.basetoolbar.BaseToolbar

import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.base.RefreshFragment
import com.hupu.tv.player.app.base.RefreshVP2Fragment
import com.hupu.tv.player.app.base.ToolbarFragment
import com.hupu.tv.player.app.bean.RedListData
import com.hupu.tv.player.app.ui.activity.MaterialDetailActivity
import com.hupu.tv.player.app.ui.activity.RedDetailActivity
import com.hupu.tv.player.app.ui.adapter.RedListAdapter
import com.hupu.tv.player.app.ui.contact.RedListContact
import com.hupu.tv.player.app.ui.presenter.RedListPresenter
import com.hupu.tv.player.app.utils.EmptyConfig
import com.softgarden.baselibrary.base.BaseActivity

import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.utils.RecyclerViewUtil
import kotlinx.android.synthetic.main.fragment_red_list.*


/**
 * @author by Dell
 * @date on 2020/6/14
 * @describe
 */
//RedListPresenter
class RedListFragment : RefreshVP2Fragment<RedListPresenter>(), RedListContact.Display {
    private var sportId = ""
    private lateinit var adapter: RedListAdapter

    override val layoutId: Int
        get() = R.layout.fragment_red_list

    override val baseActivity: BaseActivity<*>?
        get() = activity as BaseActivity<*>

    override fun onRequestList(list: List<RedListData?>?) {
        mStatusLayoutManager.showSuccessLayout()
        setLoadMore(adapter, list, EmptyConfig.NO_DETAIL_RED)
    }


    override val ctx: Context?
        get() = super.ctx

    override fun initEventAndData() {
        sportId = arguments?.getString(Constants.MATCH_BEAN_ID) ?: ""
        initRefreshLayout()
        initRecyclerView()
        initAdapter()
        initStatusLayout(mRefreshLayout as View)
        mStatusLayoutManager.showLoadingLayout()
    }

    private fun initAdapter() {
        mRecyclerView?.layoutManager = LinearLayoutManager(requireContext())
        adapter = RedListAdapter(R.layout.item_red_list, this)
        mRecyclerView?.adapter = adapter
        RecyclerViewUtil.addItemDecoration(requireActivity(),mRecyclerView!!,R.color.transparent,10f)
        adapter.setOnItemClickListener { adapter, view, position ->
            val intent = Intent(requireActivity(), MaterialDetailActivity::class.java)
            val redListData = adapter.getItem(position) as RedListData
            intent.putExtra(Constants.RED_DETAIL_ID, redListData.id)
            intent.putExtra(Constants.SPORT_TYPE, sportId)
            startActivity(intent)
        }
    }


    companion object {
        fun newInstance(id: String): RedListFragment {
            val args = Bundle()
            val fragment = RedListFragment()
            args.putString(Constants.MATCH_BEAN_ID, id)
            fragment.arguments = args
            return fragment
        }
    }

    override fun lazyLoad() {
        presenter?.getRedList(sportId, mPage)

    }
}